const pool = require('../config_db');

exports.renderAddCurriculo = (req, res) => {
    res.render('adicionar-curriculo');
};

exports.addCurriculo = async (req, res) => {
    //console.log('Adicionando curriculo');

    try {
        const {
            tipoInteresse, tipoAcesso, nome, email, celular, nascimento, rg,
            orgao, cpf, sexo, estadoCivil, creci, cep, logradouro, 
            numero, complemento, bairro, cidade, estado, cnpj, razaoSocial, 
            nomeResponsavel, celularResponsavel, emailResponsavel, creciJuridico, formaPagamento, nomeFavorecido, banco, cpfFavorecido, agencia, conta, tipoConta, operacao, chavePix, descricaoServicos 
        } = req.body;

        let anexo = '';

        //console.log(req.body);
        //console.log(req.file);

        if (req.file) {
            anexo = `uploads/${req.file.filename}`;
        }


        const query = `
            INSERT INTO curriculos (tipoInteresse, tipoAcesso, nome, email, celular, dataNascimento, rg, orgao, cpf, sexo, estadoCivil, cep, logradouro, numero, complemento, bairro, cidade, estado, cnpj, razaoSocial, nomeResponsavel, celularResponsavel, emailResponsavel, creci, creciJuridico, anexo, formaPagamento, nomeFavorecido, banco, cpfFavorecido, agencia, conta, tipoConta, operacao, chavePix, descricaoServicos)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        `;


        const sanitizeValue = (value) => (value === undefined || value === "" ? null : value);

        const values = [
            sanitizeValue(tipoInteresse), sanitizeValue(tipoAcesso), sanitizeValue(nome), 
            sanitizeValue(email), sanitizeValue(celular), sanitizeValue(nascimento), 
            sanitizeValue(rg), sanitizeValue(orgao), sanitizeValue(cpf), 
            sanitizeValue(sexo), sanitizeValue(estadoCivil), sanitizeValue(cep), 
            sanitizeValue(logradouro), sanitizeValue(numero), sanitizeValue(complemento), 
            sanitizeValue(bairro), sanitizeValue(cidade), sanitizeValue(estado), 
            sanitizeValue(cnpj), sanitizeValue(razaoSocial), sanitizeValue(nomeResponsavel), 
            sanitizeValue(celularResponsavel), sanitizeValue(emailResponsavel), 
            sanitizeValue(creci), sanitizeValue(creciJuridico), sanitizeValue(anexo)
            , sanitizeValue(formaPagamento), sanitizeValue(nomeFavorecido), sanitizeValue(banco), sanitizeValue(cpfFavorecido), sanitizeValue(agencia), sanitizeValue(conta), sanitizeValue(tipoConta), sanitizeValue(operacao), sanitizeValue(chavePix), sanitizeValue(descricaoServicos)
        ];
        
        //console.log("Valores tratados:", values);

        // 🔹 Alterado para usar `await pool.query(...)` sem callback
        const [result] = await pool.query(query, values);
        
        //console.log('Passou na query');

        res.status(200).json({
            success: true,
            message: 'Currículo inserido com sucesso!'
        });

    } catch (err) {
        console.error('Erro ao inserir dados no banco:', err);
        res.status(500).json({
            success: false,
            message: 'Erro ao salvar os dados no banco de dados.',
            error: err.message
        });
    }
};

exports.renderCurriculos = async (req, res) => {
    const query = "SELECT * FROM curriculos";
    
    try {
        // Usa o método `promise().query()` para trabalhar com Promises
        const [results] = await pool.query(query);
         res.render('listar-curriculos', { curriculos: results });

    } catch (err) {
        console.error("Erro ao buscar anúncios:", err.message);
        res.status(500).send("Erro ao buscar os anúncios.");
    }

};

exports.renderCurriculoId = (req, res) => {
    res.render('ver-curriculo');
};

exports.getCurriculoId = async (req, res) => {
    const { id } = req.params;
    //console.log(id)

    const query = `
        SELECT * FROM curriculos WHERE id = ?;`;

    try {
        const [results] = await pool.query(query, [id]);
        
        if (results.length === 0) {
            return res.status(404).json({ message: "Currículo não encontrado" });
        }

        let curriculo = results[0];

        res.json(curriculo);

    } catch (err) {
        console.error("Erro ao buscar o curriculo:", err.message);
        res.status(500).send("Erro ao buscar o curriculo.");
    }
};








