
const pool = require('../config_db');
const moment = require('moment'); 

exports.agendar = async (req, res) => {
    const { email, nome, telefone, data, hora, observacoes, imovelSelecionado, emailColaborador, nomeColaborador } = req.body;

    console.log('Entrou no agendar visita');
    console.log(req.body);

    try {
        const connection = await pool.getConnection();

        // Verifica se já existe uma visita para essa data e hora
        const [rows] = await connection.execute(
            'SELECT * FROM visitas WHERE email = ? AND data_hora = ?',
            [email, `${moment(data, "DD/MM/YYYY").format("YYYY-MM-DD")} ${hora}:00`]
        );

        if (rows.length > 0) {
            connection.release();
            return res.status(400).json({ message: 'Já existe uma visita para essa data e hora.' });
        }

        // Converte data e hora para o formato correto
        const dataHoraFormatada = `${moment(data, "DD/MM/YYYY").format("YYYY-MM-DD")} ${hora}:00`;

        // Insere a visita no banco de dados
        const [result] = await connection.execute(
            'INSERT INTO visitas (nome, email, telefone, data_hora, observacoes, imovelSelecionado, emailColaborador, nomeColaborador) VALUES (?, ?, ?, ?, ?, ?, ?, ?)',
            [nome, email, telefone, dataHoraFormatada, observacoes, imovelSelecionado, emailColaborador, nomeColaborador]
        );

        connection.release();

        return res.status(201).json({ message: 'Visita cadastrada com sucesso.', visitaId: result.insertId });

    } catch (error) {
        console.error('Erro ao cadastrar visita:', error);
        return res.status(500).json({ message: 'Erro interno do servidor.' });
    }
};


exports.getAllVisitas = async (req, res) => {
    const query = `
        SELECT 
            *
        FROM visitas u
        ORDER BY u.data_hora ASC`;

    try {
        // Usa o método `promise().query()` para trabalhar com Promises
        const [results] = await pool.query(query);
        res.json({ visitas: results });

    } catch (err) {
        console.error("Erro ao buscar visitas:", err.message);
        res.status(500).send("Erro ao buscar os visitas.");
    }
};

exports.editarVisita = async (req, res) => {
    console.log('Entrou aqui edição visita');
    const { id } = req.params;  // O ID do administrador será passado como parâmetro na URL
    const { status } = req.body;
    
    console.log("req.body");
    console.log(req.body);
    console.log("req.params");
    console.log(req.params);
    

    // Monta a query dinamicamente para atualizar ou não a senha
    let query = `
        UPDATE visitas
        SET status = ?`;
    
    let queryParams = [status];

    query += ` WHERE id = ?`;  // A cláusula WHERE é sempre necessária
    queryParams.push(id);  // Adiciona o ID no final dos parâmetros

    try {
        const [result] = await pool.query(query, queryParams);

        if (result.affectedRows > 0) {
            res.status(200).json({ message: "Visita atualizada com sucesso" });
        } else {
            res.status(404).json({ message: "Visita não encontrada" });
        }
    } catch (err) {
        console.error("Erro ao atualizar visita:", err.message);
        res.status(500).send("Erro ao atualizar o visita.");
    }
};