const jwt = require('jsonwebtoken');
const cookie = require('cookie');
require('dotenv').config();

// Função middleware para verificar o token
const authMiddleware = (req, res, next) => {
  const cookies = cookie.parse(req.headers.cookie || '');
  const token = cookies.token;

  if (!token) {
    return res.status(401).render('index', {
      message: 'Token não fornecido. Faça o login primeiro.'
    });
  }

  const secret = process.env.SECRET;

  jwt.verify(token, secret, (err, decoded) => {
    if (err) {
      return res.status(401).render('index', {
        message: 'Token inválido ou expirado. Faça o login novamente.'
      });
    }
    // O token é válido, armazene o token e o ID do usuário no objeto de solicitação para uso posterior
    req.token = token;
    req.userId = decoded.id;

    // Continue para a próxima rota
    next();
  });
};

module.exports = authMiddleware;