const express = require('express');
const router = express.Router();
const controller = require('../controllers/aluguelExpressController');
const multer = require('multer');
const path = require('path');

// Configuração do multer para salvar o arquivo
const storage = multer.diskStorage({
    destination: (req, file, cb) => {
        cb(null, 'public/uploads/'); // Pasta onde os arquivos serão salvos
    },
    filename: (req, file, cb) => {
        cb(null, Date.now() + path.extname(file.originalname));  // Gera um nome único para o arquivo
    }
});

const upload = multer({ storage: storage });
router.post('/aluguel/express/adicionar', upload.array('arquivos', 20), controller.addAluguelExpress);

/*router.post('/aluguel/express/adicionar', upload.none(), controller.addAluguelExpress);*/

// Rota para exibir todos os currículos
router.get('/solicitacoes/aluguel/express', controller.renderAluguelExpress);

router.get('/aluguel/express/listar', controller.getAllAluguelExpress);
router.get('/aluguel/express/:id', controller.getAluguelExpressId);

router.get('/aluguel/express/ver/:id', controller.renderAluguelExpressId);

/*router.get('/anuncio/aprovar/:id', controller.aprovarAnuncio);
router.get('/anuncio/reprovar/:id', controller.reprovarAnuncio);
router.get('/anuncio/pendente/:id', controller.pendenteAnuncio);*/

router.get('/aluguel/aprovar/:id', controller.aprovarAluguel);
router.get('/aluguel/reprovar/:id', controller.reprovarAluguel);
router.get('/aluguel/pendente/:id', controller.pendenteAluguel);

module.exports = router;
