const express = require('express');
const router = express.Router();
const multer = require('multer');
const controller = require('../controllers/anuncieController');
const path = require('path');

// Configuração do multer para salvar o arquivo
const storage = multer.diskStorage({
    destination: (req, file, cb) => {
        cb(null, 'public/uploads/'); // Pasta onde os arquivos serão salvos
    },
    filename: (req, file, cb) => {
        cb(null, Date.now() + path.extname(file.originalname));  // Gera um nome único para o arquivo
    }
});

const upload = multer({ storage: storage });

// Rota para exibir a página de login
router.get('/anuncie/adicionar', controller.renderAddAnuncio);

// Rota para adicionar o currículo, incluindo o upload de arquivo
//router.post('/anuncie/adicionar', upload.single('curriculo'), controller.addCurriculo);

router.post('/anuncie/adicionar', upload.array('imagens', 30), controller.addAnuncio);


// Rota para exibir todos os currículos
router.get('/solicitacoes/anuncio', controller.renderAnuncios);


router.get('/anuncios/listar', controller.getAllAnuncio);
router.get('/anuncio/:id', controller.getAnuncioId);

router.get('/anuncio/ver/:id', controller.renderAnuncioId);

router.get('/anuncio/aprovar/site/:id', controller.aprovarAnuncio);
router.get('/anuncio/aprovar/zap/:id', controller.aprovarAnuncioZap);
router.get('/anuncio/aprovar/site/zap/:id', controller.aprovarAnuncioSiteZap);
router.get('/anuncio/reprovar/:id', controller.reprovarAnuncio);
router.get('/anuncio/pendente/:id', controller.pendenteAnuncio);

module.exports = router;
