const express = require('express');
const router = express.Router();
const multer = require('multer');
const controller = require('../controllers/imovelController');
const path = require('path');

// Configuração do multer para salvar o arquivo
const storage = multer.diskStorage({
    destination: (req, file, cb) => {
        cb(null, 'public/uploads/'); // Pasta onde os arquivos serão salvos
    },
    filename: (req, file, cb) => {
        cb(null, Date.now() + path.extname(file.originalname));  // Gera um nome único para o arquivo
    }
});

const upload = multer({ storage: storage });


// Rota para exibir todos os currículos
router.get('/imoveis', controller.renderImoveis);


router.get('/imovel/listar', controller.getAllImoveis);
/*router.get('/imovel/:id', controller.getImovelId);

router.get('/imovel/ver/:id', controller.renderImovelId);

router.get('/imovel/aprovar/:id', controller.aprovarImovel);
router.get('/imovel/reprovar/:id', controller.reprovarImovel);
router.get('/imovel/pendente/:id', controller.pendenteImovel);*/

module.exports = router;
