const pool = require('../config_db');

exports.renderAluguelExpress = (req, res) => {
    res.render('listar-aluguel-express');
};

/*exports.addAluguelExpress = async (req, res) => {
    console.log(req.body)
    const { idImovel, imovel, nomeCompleto, email, telefone, tipoGarantia, fiadorNome, fiadorEmail, fiadorCelular, fiadorNascimento, fiadorCpf, fiadorRg, fiadorOrgao, fiadorNacionalidade, fiadorProfissao, fiadorConjugeNome,  fiadorConjugeCelular, fiadorConjugeNascimento, fiadorConjugeCpf, fiadorConjugeRg, fiadorConjugeOrgao, fiadorConjugeNacionalidade, fiadorConjugeProfissao, fiadorSexo, fiadorEstadoCivil, cepFiador, logradouroFiador, numeroFiador, complementoFiador, bairroFiador, cidadeFiador, estadoFiador, cepImovelFiador, logradouroImovelFiador, numeroImovelFiador, complementoImovelFiador, bairroImovelFiador, cidadeImovelFiador, estadoImovelFiador, valorOnus, valorProposta }  = req.body;
    
    console.log(req.files);
    
    const arquivosEnviados = req.files?.map(file => file.path) || [];
    
    console.log(arquivosEnviados)
    
    var statusLocacao = 'Pendente';

    const queryAluguelExpress = `INSERT INTO solicitacoes_aluguel_express (id_imovel, tituloImovel, nomeCompleto, email, celular, garantia, valorProposta, nomeFiador, emailFiador, celularFiador, dataNascFiador, cpfFiador, rgFiador, orgaoFiador, nacionalidadeFiador, profissaoFiador, nomeConjugeFiador, celularConjugeFiador, dataNascConjugeFiador, cpfConjugeFiador, rgConjugeFiador, orgaoConjugeFiador, nacionalidadeConjugeFiador, profissaoConjugeFiador, sexoFiador, estadoCivilFiador, cepFiador, logradouroFiador, numeroFiador, complementoFiador, bairroFiador, cidadeFiador, estadoFiador, cepImovelGarantia, logradouroImovelGarantia, numeroImovelGarantia, complementoImovelGarantia, bairroImovelGarantia, cidadeImovelGarantia, estadoImovelGarantia, valorOnusImovel, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`;

    const valuesAluguelExpress = [idImovel, imovel, nomeCompleto, email, telefone, tipoGarantia, valorProposta, fiadorNome, fiadorEmail, fiadorCelular, fiadorNascimento, fiadorCpf, fiadorRg, fiadorOrgao, fiadorNacionalidade, fiadorProfissao, fiadorConjugeNome, fiadorConjugeCelular, fiadorConjugeNascimento, fiadorConjugeCpf, fiadorConjugeRg, fiadorConjugeOrgao, fiadorConjugeNacionalidade, fiadorConjugeProfissao, fiadorSexo, fiadorEstadoCivil, cepFiador, logradouroFiador, numeroFiador, complementoFiador, bairroFiador, cidadeFiador, estadoFiador, cepImovelFiador, logradouroImovelFiador, numeroImovelFiador, complementoImovelFiador, bairroImovelFiador, cidadeImovelFiador, estadoImovelFiador, valorOnus, statusLocacao ];
    

    try {
       const [result] = await pool.query(queryAluguelExpress, valuesAluguelExpress);
       res.status(200).json({ message: "Locação inserida com sucesso", idImovel });

    } catch (err) {
        console.error("Erro ao adicionar locação:", err.message);
        res.status(500).send("Erro ao adicionar locação.");
    }

};*/

exports.addAluguelExpress = async (req, res) => {
    //console.log(req.body);
    const { 
        idImovel, imovel, nomeCompleto, email, telefone, tipoGarantia, fiadorNome, fiadorEmail, fiadorCelular, fiadorNascimento, fiadorCpf, fiadorRg, fiadorOrgao, fiadorNacionalidade, fiadorProfissao, fiadorConjugeNome, fiadorConjugeCelular, fiadorConjugeNascimento, fiadorConjugeCpf, fiadorConjugeRg, fiadorConjugeOrgao, fiadorConjugeNacionalidade, fiadorConjugeProfissao, fiadorSexo, fiadorEstadoCivil, cepFiador, logradouroFiador, numeroFiador, complementoFiador, bairroFiador, cidadeFiador, estadoFiador, cepImovelFiador, logradouroImovelFiador, numeroImovelFiador, complementoImovelFiador, bairroImovelFiador, cidadeImovelFiador, estadoImovelFiador, valorOnus, valorProposta 
    } = req.body;
    console.log(req.body);


    // Verifique se os arquivos foram enviados e mapear os arquivos
    const arquivosEnviados = req.files.map((file, index) => {
        const documentos = JSON.parse(req.body.documentos || '[]'); // Receber como JSON
        const tipoDocumento = documentos[index]?.tipoDocumento || 'indefinido'; // Garantir o tipoDocumento correspondente
    
        return {
            caminho: file.path,
            nome: file.originalname,
            tipoDocumento
        };
    });


    console.log(arquivosEnviados);

    var statusLocacao = 'Pendente';

    // Inserção da locação na tabela solicitacoes_aluguel_express
    const queryAluguelExpress = `
        INSERT INTO solicitacoes_aluguel_express (
            id_imovel, tituloImovel, nomeCompleto, email, celular, garantia, valorProposta, nomeFiador, emailFiador, celularFiador, dataNascFiador, cpfFiador, rgFiador, orgaoFiador, nacionalidadeFiador, profissaoFiador, nomeConjugeFiador, celularConjugeFiador, dataNascConjugeFiador, cpfConjugeFiador, rgConjugeFiador, orgaoConjugeFiador, nacionalidadeConjugeFiador, profissaoConjugeFiador, sexoFiador, estadoCivilFiador, cepFiador, logradouroFiador, numeroFiador, complementoFiador, bairroFiador, cidadeFiador, estadoFiador, cepImovelGarantia, logradouroImovelGarantia, numeroImovelGarantia, complementoImovelGarantia, bairroImovelGarantia, cidadeImovelGarantia, estadoImovelGarantia, valorOnusImovel, status
        ) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
    `;

    const valuesAluguelExpress = [
        idImovel, imovel, nomeCompleto, email, telefone, tipoGarantia, valorProposta, fiadorNome, fiadorEmail, fiadorCelular, fiadorNascimento, fiadorCpf, fiadorRg, fiadorOrgao, fiadorNacionalidade, fiadorProfissao, fiadorConjugeNome, fiadorConjugeCelular, fiadorConjugeNascimento, fiadorConjugeCpf, fiadorConjugeRg, fiadorConjugeOrgao, fiadorConjugeNacionalidade, fiadorConjugeProfissao, fiadorSexo, fiadorEstadoCivil, cepFiador, logradouroFiador, numeroFiador, complementoFiador, bairroFiador, cidadeFiador, estadoFiador, cepImovelFiador, logradouroImovelFiador, numeroImovelFiador, complementoImovelFiador, bairroImovelFiador, cidadeImovelFiador, estadoImovelFiador, valorOnus, statusLocacao
    ];

    try {
        // Inserir dados da locação
        const [result] = await pool.query(queryAluguelExpress, valuesAluguelExpress);
        const idAluguelExpress = result.insertId;

        // Inserir os arquivos na tabela documentos_aluguel_express
        const queryDocumentos = `
            INSERT INTO documentos_aluguel_express (id_aluguel_express, caminho, nome, tipo) 
            VALUES (?, ?, ?, ?)
        `;

        // Inserir cada arquivo com seu tipo de documento
        for (const arquivo of arquivosEnviados) {
            //console.log("arquivo")
            //console.log(arquivo)
            await pool.query(queryDocumentos, [idAluguelExpress, arquivo.caminho, arquivo.nome, arquivo.tipoDocumento]);
        }

        res.status(200).json({ message: "Locação inserida com sucesso", idImovel, idAluguelExpress });
    } catch (err) {
        console.error("Erro ao adicionar locação:", err.message);
        res.status(500).send("Erro ao adicionar locação.");
    }
};



// Função para obter todos os anúncios com todas as informações
exports.getAllAluguelExpress = async (req, res) => {
    const query = `
        SELECT * FROM solicitacoes_aluguel_express`;

    try {
        // Usa o método `promise().query()` para trabalhar com Promises
        const [results] = await pool.query(query);
        res.json({ solicitacoes: results });

    } catch (err) {
        console.error("Erro ao buscar solicitações:", err.message);
        res.status(500).send("Erro ao buscar solicitações.");
    }
};

exports.renderAluguelExpressId = (req, res) => {
    res.render('ver-aluguel-express');
};

exports.getAluguelExpressId = async (req, res) => {
    const { id } = req.params;

    // Query com o JOIN
    const query = `
        SELECT 
            sae.*, 
            dae.caminho AS documentoCaminho,
            dae.nome AS documentoNome,
            dae.tipo AS documentoTipo
        FROM 
            solicitacoes_aluguel_express sae
        LEFT JOIN 
            documentos_aluguel_express dae
        ON 
            sae.id = dae.id_aluguel_express
        WHERE 
            sae.id = ?
    `;

    try {
        const [results] = await pool.query(query, [id]);

        if (results.length === 0) {
            return res.status(404).json({ message: "Solicitação não encontrada" });
        }

        // Organizando os dados da solicitação e os documentos em formato estruturado
        const aluguelExpress = {
            ...results[0], // Dados da solicitação
            documentos: results
                .filter(doc => doc.documentoCaminho) // Filtra apenas os registros com documentos
                .map(doc => ({
                    caminho: doc.documentoCaminho,
                    nome: doc.documentoNome,
                    tipo: doc.documentoTipo,
                })),
        };

        // Removendo duplicatas do objeto principal (se necessário)
        delete aluguelExpress.documentoCaminho;
        delete aluguelExpress.documentoNome;
        delete aluguelExpress.documentoTipo;
        
        console.log("aluguelExpress");
        console.log(aluguelExpress);

        res.json(aluguelExpress);
    } catch (err) {
        console.error("Erro ao buscar solicitação:", err.message);
        res.status(500).send("Erro ao buscar solicitação.");
    }
};


/*exports.getAluguelExpressId = async (req, res) => {
    const { id } = req.params;
    

    const query = `
        SELECT * FROM solicitacoes_aluguel_express WHERE id = ?`;

    try {
        const [results] = await pool.query(query, [id]);
        
        if (results.length === 0) {
            return res.status(404).json({ message: "Solicitação não encontrada" });
        }

        let aluguelExpress = results[0];

        res.json(aluguelExpress);

    } catch (err) {
        console.error("Erro ao buscar solicitação:", err.message);
        res.status(500).send("Erro ao buscar solicitação.");
    }
};*/

exports.aprovarAluguel = async (req, res) => {
    console.log('Acessou rota');
    const { id } = req.params;
    console.log(id);
    const query = `UPDATE solicitacoes_aluguel_express SET status = ? WHERE id = ?`;
    const values = ['Aprovado', id];

    try {
        const [result] = await pool.query(query, values); // ✅ Uso correto com `await`
        
        if (result.affectedRows === 0) {
            return res.status(404).json({ message: "Aluguel não encontrado" });
        }

        return res.status(200).json({
            message: "Aluguel aprovado com sucesso",
            aluguel: id // Retorna os dados atualizados
        });
        
    } catch (err) {
        console.error("Erro ao alterar aluguel:", err.message);
        res.status(500).send('Erro ao alterar aluguel.');
    }
};

exports.reprovarAluguel = async (req, res) => {
    const { id } = req.params;
    const query = `UPDATE solicitacoes_aluguel_express SET status = ? WHERE id = ?`;
    const values = ['Reprovado', id];

    try {
        const [result] = await pool.query(query, values); // ✅ Uso correto com `await`
        
        if (result.affectedRows === 0) {
            return res.status(404).json({ message: "Aluguel não encontrado" });
        }

         return res.status(200).json({
            message: "Aluguel reprovado com sucesso",
            aluguel: id // Retorna os dados atualizados
        });
        
    } catch (err) {
        console.error("Erro ao alterar aluguel:", err.message);
        res.status(500).send('Erro ao alterar aluguel.');
    }
};

exports.pendenteAluguel = async (req, res) => {
    const { id } = req.params;
    const query = `UPDATE solicitacoes_aluguel_express SET status = ? WHERE id = ?`;
    const values = ['Pendente', id];

    try {
        const [result] = await pool.query(query, values); // ✅ Uso correto com `await`
        
        if (result.affectedRows === 0) {
            return res.status(404).json({ message: "Aluguel não encontrado" });
        }

         return res.status(200).json({
            message: "Aluguel pendente.",
            aluguel: id // Retorna os dados atualizados
        });
        
    } catch (err) {
        console.error("Erro ao alterar aluguel:", err.message);
        res.status(500).send('Erro ao alterar aluguel.');
    }
};


