const axios = require('axios');
const fs = require('fs');
const path = require('path');
const pool = require('../config_db');
const { stringify } = require('flatted');

// Cabeçalhos para as requisições
const headers = {
    'Content-Type': 'application/json',
    app_token: '49c6a333-7dc5-4b44-aa2d-9a36abd2e7b5',
    access_token: '7cf3d372-01f0-44f7-b294-d1d80c6fb2db'
};



/*exports.getUsuarios = async (req, res) => {
    const email = req.params.email;  // Obtém o e-mail passado na URL
    const url = `https://api.superlogica.net/v2/financeiro/clientes?apenasColunasPrincipais=0&apenasPessoasJuridicas=0&pagina=1&itensPorPagina=50&pesquisaEmTudo=${email}&status=2`;

    try {
        const response = await axios.get(url, { headers });
        
        if (response.data.length > 0) {
            //console.log(response.data)
            res.json({ usuarios: response.data });
        } else {
        //console.log('Executando2')
            res.status(404).json({ message: 'Usuário não encontrado' });
        }
    } catch (err) {
        //console.log('Executando3')
        console.error("Erro ao buscar usuários:", err.message);
        res.status(500).json({ message: 'Erro ao buscar usuários' });
    }
};*/

/*exports.getUsuarios = async (req, res) => {
    const email = req.params.email;  
    const tipo = req.query.tipo;

    
    var url = ``;
    
    if(tipo == 'Proprietário'){
        url = `http://apps.superlogica.net/imobiliaria/api/proprietarios`;
        
        try {
            const response = await axios.get(url, { headers });
            
    
            if (response.data.data.length > 0) {
                const proprietarios = response.data.data;
                //console.log(`Total de proprietários recebidos: ${proprietarios.length}`);
                //console.log('Email: ' + email)
                
            
                proprietarios.forEach(p => {
                    // Verifica se o e-mail não está vazio ou nulo
                    if (p.st_email_pes && p.st_email_pes.trim() !== '') {
                        
                        // Se o e-mail contiver ";", pega a parte antes do ";"
                        let emailTratado = p.st_email_pes;
                        if (emailTratado.includes(';')) {
                            emailTratado = emailTratado.split(';')[0];  // Pega o primeiro elemento antes do ";"
                        }
                        //console.log(`Email tratado: ${emailTratado}`);
                        
                        // Verifica se o e-mail (tratado) é igual ao e-mail fornecido (ignorando maiúsculas/minúsculas)
                        if (emailTratado.trim().toLowerCase() === email.trim().toLowerCase()) {
                            //console.log('Email encontrado no proprietário');
                            proprietario = p;
                            // Aqui você pode fazer a lógica necessária, como retornar o proprietário
                        }
                    }
                });
                
                if (proprietario) {
                    //console.log("Enviando proprietario: " + proprietario.st_email_pes)
                    //console.log(proprietario)
                    return res.json({ usuario: proprietario });
                } else {
                    return res.status(404).json({ message: 'Usuário não encontrado' });
                }
    
    
            
                
            } else {
                res.status(404).json({ message: 'Nenhum proprietário encontrado na API' });
            }
    
        } catch (err) {
            console.error("Erro ao buscar usuários:", err.message);
            res.status(500).json({ message: 'Erro ao buscar usuários' });
        }
    }else{
        url = `http://apps.superlogica.net/imobiliaria/api/locatarios`;
        
        try {
            const response = await axios.get(url, { headers });
            
    
            if (response.data.data.length > 0) {
                const locatarios = response.data.data;
                //console.log(`Total de locatarios recebidos: ${proprietarios.length}`);
                //console.log('Email: ' + email)
                
            
                locatarios.forEach(p => {
                    // Verifica se o e-mail não está vazio ou nulo
                    if (p.st_email_pes && p.st_email_pes.trim() !== '') {
                        
                        // Se o e-mail contiver ";", pega a parte antes do ";"
                        let emailTratado = p.st_email_pes;
                        if (emailTratado.includes(';')) {
                            emailTratado = emailTratado.split(';')[0];  // Pega o primeiro elemento antes do ";"
                        }
                        //console.log(`Email tratado: ${emailTratado}`);
                        
                        // Verifica se o e-mail (tratado) é igual ao e-mail fornecido (ignorando maiúsculas/minúsculas)
                        if (emailTratado.trim().toLowerCase() === email.trim().toLowerCase()) {
                            //console.log('Email encontrado no locatário');
                            locatario = p;
                        }
                    }
                });
                
                if (locatario) {
                    //console.log("Enviando locatario: " + proprietario.st_email_pes)
                    //console.log(proprietario)
                    return res.json({ usuario: locatario });
                } else {
                    return res.status(404).json({ message: 'Usuário não encontrado' });
                }
    
    
            
                
            } else {
                res.status(404).json({ message: 'Nenhum locatário encontrado na API' });
            }
    
        } catch (err) {
            console.error("Erro ao buscar usuários:", err.message);
            res.status(500).json({ message: 'Erro ao buscar usuários' });
        }
    }
    

    
};   */

exports.getUsuarios = async (req, res) => {
    const email = req.params.email;  
    const tipo = req.query.tipo;
    
    let urlProprietario = `http://apps.superlogica.net/imobiliaria/api/proprietarios`;
    let urlLocatario = `http://apps.superlogica.net/imobiliaria/api/locatarios`;

    let proprietario = null;
    let locatario = null;
    
    console.log(email)
    console.log(tipo)
    
    try {
        if (tipo === 'Proprietário' || tipo === 'Locatário e Proprietário') {
            const responseProprietarios = await axios.get(urlProprietario, { headers });
            
            if (responseProprietarios.data.data.length > 0) {
                const proprietarios = responseProprietarios.data.data;
                
                proprietarios.forEach(p => {
                    if (p.st_email_pes && p.st_email_pes.trim() !== '') {
                        let emailTratado = p.st_email_pes;
                        if (emailTratado.includes(';')) {
                            emailTratado = emailTratado.split(';')[0];
                        }
                        
                        if (emailTratado.trim().toLowerCase() === email.trim().toLowerCase()) {
                            proprietario = p;
                        }
                    }
                });
            }
        }

        if (tipo === 'Locatário' || tipo === 'Locatário e Proprietário') {
            const responseLocatarios = await axios.get(urlLocatario, { headers });
            
            if (responseLocatarios.data.data.length > 0) {
                const locatarios = responseLocatarios.data.data;
                console.log("locatarios")
                console.log(locatarios)
                
                locatarios.forEach(p => {
                    if (p.st_email_pes && p.st_email_pes.trim() !== '') {
                        let emailTratado = p.st_email_pes;
                        if (emailTratado.includes(';')) {
                            emailTratado = emailTratado.split(';')[0];
                        }
                        
                        if (emailTratado.trim().toLowerCase() === email.trim().toLowerCase()) {
                            locatario = p;
                        }
                    }
                });
            }
        }

        // Verifica os casos e envia os dados conforme o tipo
        if (tipo === 'Locatário e Proprietário') {
            if (proprietario && locatario) {
                return res.json({ usuario: { proprietario, locatario } });
            } else {
                return res.status(404).json({ message: 'Usuários não encontrados' });
            }
        } else if (tipo === 'Proprietário' && proprietario) {
            return res.json({ usuario: proprietario });
        } else if (tipo === 'Locatário' && locatario) {
                console.log("usuario")
                console.log(locatario)
            return res.json({ usuario: locatario });
        } else {
            return res.status(404).json({ message: 'Usuário não encontrado' });
        }
        
    } catch (err) {
        console.error("Erro ao buscar usuários:", err.message);
        res.status(500).json({ message: 'Erro ao buscar usuários' });
    }
};

exports.getUsuariosDeslogado = async (req, res) => {
    const email = req.params.email;  // Obtém o e-mail passado na URL
    const { cpf, cnpj, dataNascimento } = req.query;


    
    const url = `https://api.superlogica.net/v2/financeiro/clientes?apenasColunasPrincipais=0&apenasPessoasJuridicas=0&pagina=1&itensPorPagina=50&pesquisaEmTudo=${email}&status=2`;

    try {
        const response = await axios.get(url, { headers });
        
        //console.log(response)
        
        if (response.data.length > 0) {
            console.log(response.data)
            console.log(response.data[0]['st_cgc_sac'])
            console.log(cpf);
            console.log(response.data[0]['dt_nascimento_sac'])
            console.log(dataNascimento);
            if(cpf.length <= 14){
                //console.log('Entrou 1')
                if(response.data[0]['st_cgc_sac'] == cpf && response.data[0]['dt_nascimento_sac'] == dataNascimento){
                console.log('Entrou 2')
                    res.json({ usuarios: response.data });
                }else{
                console.log('Entrou 3')
                    res.status(404).json({ message: 'Usuário não encontrado' });
                }
            }else{
                
                console.log('Entrou 4')
                if(response.data[0]['st_cgc_sac'] == cnpj){
                    
                //console.log('Entrou 5')
                    res.json({ usuarios: response.data });
                }else{
                    
                //console.log('Entrou 6')
                    res.status(404).json({ message: 'Usuário não encontrado' });
                }
            }
            
        } else {
        //console.log('Executando2')
            res.status(404).json({ message: 'Usuário não encontrado' });
        }
    } catch (err) {
        //console.log('Executando3')
        console.error("Erro ao buscar usuários:", err.message);
        res.status(500).json({ message: 'Erro ao buscar usuários' });
    }
};

exports.getRepasse = async (req, res) => {
    const id = req.params.id;  // Obtém o ID passado na URL
    //console.log(id);
    const url = `http://apps.superlogica.net/imobiliaria/api/repasses?idContrato[0]=${id}`;

    try {
        const response = await axios.get(url, { headers });

        // Verifica se o campo 'data' existe e se tem elementos
        if (response.data.data && response.data.data.length > 0) {
            
            //console.log(response.data.data); // Exibe os dados dos contratos
            res.json({ repasses: response.data.data }); // Retorna os contratos
        } else {
            //console.log('Entrou 2');
            //console.log(response.data); // Exibe a resposta completa para depuração
            res.status(404).json({ message: 'Repasse não encontrado' });
        }
    } catch (err) {
        //console.log('Entrou 3');
        //console.error("Erro ao buscar contratos:", err.message);
        res.status(500).json({ message: 'Erro ao buscar repasse' });
    }
};

exports.getContratos = async (req, res) => {
    const id = req.params.id;  // Obtém o ID passado na URL
    //console.log(id);
    const url = `http://apps.superlogica.net/imobiliaria/api/contratos?comStatus=andamento&PROPRIETARIOS[0]=${id}`;

    try {
        const response = await axios.get(url, { headers });

        // Verifica se o campo 'data' existe e se tem elementos
        if (response.data.data && response.data.data.length > 0) {
            
            //console.log(response.data.data); // Exibe os dados dos contratos
            res.json({ contratos: response.data.data }); // Retorna os contratos
        } else {
            //console.log('Entrou 2');
            //console.log(response.data); // Exibe a resposta completa para depuração
            res.status(404).json({ message: 'Contrato não encontrado' });
        }
    } catch (err) {
        //console.log('Entrou 3');
        //console.error("Erro ao buscar contratos:", err.message);
        res.status(500).json({ message: 'Erro ao buscar contratos' });
    }
};

exports.getAllContratos = async (req, res) => {
    const idUser = req.params.idUser; // Obtém o ID do usuário da URL
    //console.log(`ID do usuário: ${idUser}`);

    const url = `http://apps.superlogica.net/imobiliaria/api/contratos`;

    try {
        const response = await axios.get(url, { headers });

        // Verifica se há contratos na resposta
        if (!response.data.data || response.data.data.length === 0) {
            return res.status(404).json({ message: "Nenhum contrato encontrado" });
        }

        const contratos = response.data.data;

        // Filtra os contratos onde o idUser está na lista de inquilinos
        const contratosFiltrados = contratos.filter(contrato => {
            if (!contrato.inquilinos || contrato.inquilinos.length === 0) {
                return false; // Se não há inquilinos, ignora o contrato
            }

            // Verifica se algum inquilino tem o mesmo id_pessoa_pes do idUser
            return contrato.inquilinos.some(inquilino => inquilino.id_pessoa_pes == idUser);
        });

        if (contratosFiltrados.length === 0) {
            return res.status(404).json({ message: "Usuário não encontrado em nenhum contrato" });
        }
        
        
        //console.log(contratosFiltrados[0].proprietarios_beneficiarios)

        res.json({ contratos: contratosFiltrados });

    } catch (err) {
        console.error("Erro ao buscar contratos:", err.message);
        res.status(500).json({ message: "Erro ao buscar contratos" });
    }
};

exports.getAllManutencao = async (req, res) => {
    //console.log('Entrou manutenção admin')
    
    const url = `http://apps.superlogica.net/imobiliaria/api/manutencoes`;
    

    try {
        const response = await axios.get(url, { headers });
        
    //console.log(response)

        // Verifica se há contratos na resposta
        if (!response.data.data || response.data.data.length === 0) {
            return res.status(404).json({ message: "Nenhuma manutenção encontrada" });
        }

        const contratos = response.data.data;

        res.json({ manutencoes: contratos });

    } catch (err) {
        console.error("Erro ao buscar contratos:", err.message);
        res.status(500).json({ message: "Erro ao buscar contratos" });
    }
    
    

};

exports.getManutencao = async (req, res) => {
    const email = req.params.idUser; // Obtém o ID do usuário da URL
    //console.log(`ID do usuário: ${idUser}`);
    //console.log(email)
    //console.log('Entrou manutenção')
    
    const url = `http://apps.superlogica.net/imobiliaria/api/contratos`;
    

    try {
        const response = await axios.get(url, { headers });

        // Verifica se há contratos na resposta
        if (!response.data.data || response.data.data.length === 0) {
            return res.status(404).json({ message: "Nenhum contrato encontrado" });
        }

        const contratos = response.data.data;
        
        //console.log(contratos.inquilinos)

        // Filtra os contratos onde o idUser está na lista de inquilinos
        const contratosFiltrados = contratos.filter(contrato => {
            if (!contrato.inquilinos || contrato.inquilinos.length === 0) {
                return false; // Se não há inquilinos, ignora o contrato
            }

            // Verifica se algum inquilino tem o mesmo id_pessoa_pes do idUser
            return contrato.inquilinos.some(inquilino => inquilino.st_email_pes.includes(email));
        });

        if (contratosFiltrados.length === 0) {
            return res.status(404).json({ message: "Usuário não encontrado em nenhum contrato" });
        }
        
        const urlManutencao = `http://apps.superlogica.net/imobiliaria/api/manutencoes?IMOVEIS[0]=${contratosFiltrados[0]['id_imovel_imo']}`
        
        const response2 = await axios.get(urlManutencao, { headers });
        
        
        console.log(response2.data)

        res.json({ manutencoes: response2.data });

    } catch (err) {
        console.error("Erro ao buscar contratos:", err.message);
        res.status(500).json({ message: "Erro ao buscar contratos" });
    }
    
    

};

exports.inserirManutencao = async (req, res) => {
    console.log('Acessou inserção manut')
    try {
        const { DT_CRIACAO_MAN, FL_PRIORIDADE_MAN, FL_SITUACAO_MAN, ID_IMOVEL_IMO, ID_LOCATARIO_IMO, ID_CONTRATO_CON, ST_DESCRICAO_MAN, FL_SOLICITANTE_MAN, FL_CATEGORIA_MAN, ST_IDENTIFICADOR_MAN, ID_PROPRIETARIO_IMO } = req.body;
        
        
        const url = `http://apps.superlogica.net/imobiliaria/api/manutencoes?DT_CRIACAO_MAN=${DT_CRIACAO_MAN}&FL_PRIORIDADE_MAN=${FL_PRIORIDADE_MAN}&FL_SITUACAO_MAN=${FL_SITUACAO_MAN}&ID_IMOVEL_IMO=${ID_IMOVEL_IMO}&ID_PROPRIETARIO_IMO=${ID_PROPRIETARIO_IMO}&ID_LOCATARIO_IMO=${ID_LOCATARIO_IMO}&ID_CONTRATO_CON=${ID_CONTRATO_CON}&ST_DESCRICAO_MAN=${ST_DESCRICAO_MAN}&FL_SOLICITANTE_MAN=${FL_SOLICITANTE_MAN}&FL_CATEGORIA_MAN=${FL_CATEGORIA_MAN}&ST_IDENTIFICADOR_MAN=${ST_IDENTIFICADOR_MAN}`
        
        console.log(req.body)
        
        const response = await axios.post(url, {}, { headers });


        // Verifica se há contratos na resposta
        if (response.data) {
            console.log(response.data)
            //return res.status(404).json({ message: "Nenhum contrato encontrado" });
        }


       
    } catch (error) {
        console.error('Erro ao enviar mensagem:', error);
        return res.status(500).json({ message: 'Erro interno do servidor.' });
    }
};

exports.atualizarManutencao = async (req, res) => {
    console.log('Acessou inserção manut')
    try {
        const { ID_MANUTENCAO_MAN } = req.body;
        
        
        const url = `http://apps.superlogica.net/imobiliaria/api/manutencoes?FL_SITUACAO_MAN=0&ID_MANUTENCAO_MAN=${ID_MANUTENCAO_MAN}`
        
        console.log(req.body)
        
        const response = await axios.put(url, {}, { headers });


        // Verifica se há contratos na resposta
        if (response.data) {
            console.log(response.data)
            //return res.status(404).json({ message: "Nenhum contrato encontrado" });
        }


       
    } catch (error) {
        console.error('Erro ao enviar mensagem:', error);
        return res.status(500).json({ message: 'Erro interno do servidor.' });
    }
};


exports.getDocsContrato = async (req, res) => {
    const id = req.params.id;  // Obtém o ID passado na URL
    //console.log(id);
    const url = `http://apps.superlogica.net/imobiliaria/api/arquivos/index?idContrato=${id}`;

    try {
        const response = await axios.get(url, { headers });

        // Verifica se o campo 'data' existe e se tem elementos
        if (response.data.data && response.data.data.length > 0) {
            console.log(response.data); // Exibe os dados dos contratos
            res.json({ contratos: response.data }); // Retorna os contratos
        } else {
            console.log(response.data); // Exibe a resposta completa para depuração
            res.status(404).json({ message: 'Contrato não encontrado' });
        }
    } catch (err) {
        console.error("Erro ao buscar contratos:", err.message);
        res.status(500).json({ message: 'Erro ao buscar contratos' });
    }
};

exports.getImoveis = async (req, res) => {
    const id = req.params.id;  // Obtém o ID passado na URL
    //console.log(id);
    const url = `http://apps.superlogica.net/imobiliaria/api/imoveis?PROPRIETARIOS[0]=${id}`;

    try {
        const response = await axios.get(url, { headers });

        // Verifica se o campo 'data' existe e se tem elementos
        if (response.data.data && response.data.data.length > 0) {
            //console.log('Entrou 1');
            //console.log(response.data.data); // Exibe os dados dos contratos
            res.json({ imoveis: response.data.data }); // Retorna os contratos
        } else {
            //console.log('Entrou 2');
            //console.log(response.data); // Exibe a resposta completa para depuração
            res.status(404).json({ message: 'Imóvel não encontrado' });
        }
    } catch (err) {
        //console.log('Entrou 3');
        console.error("Erro ao buscar Imóvel:", err.message);
        res.status(500).json({ message: 'Erro ao buscar Imóvel' });
    }
};

exports.getReport = async (req, res) => {
    const { idsacado, nomeuser, startDate, endDate } = req.query;
    //console.log("idsacado: " + idsacado)
    //console.log("nomeuser: " + nomeuser)
    //console.log("startDate: " + startDate)
    //console.log("endDate: " + endDate)

    if (!idsacado || !nomeuser || !startDate || !endDate) {
        return res.status(400).json({ message: 'Parâmetros insuficientes para gerar o relatório.' });
    }

    try {
        let init = startDate.split("/");
        let end = endDate.split("/");

        let formattedStartDate = `${init[1]}/${init[0]}/${init[2]}`;
        let formattedEndDate = `${end[1]}/${end[0]}/${end[2]}`;

        const dadosOwner = await axios.post("https://apps.superlogica.net/imobiliaria/api/relatorios/id/0026002B?PROPRIETARIOS_BENEFICIARIOS%5B0%5D%5BID_PESSOA_PES%5D=" + idsacado + "&PROPRIETARIOS_BENEFICIARIOS%5B0%5D%5BST_FANTASIA_PES%5D=" + nomeuser + "&render=pdf&getId=1", {
            DT: "selecionar",
            DT_INICIO: formattedStartDate,
            DT_FIM: formattedEndDate,
            "PROPRIETARIOS_BENEFICIARIOS[0][ID_PESSOA_PES]": idsacado,
            "PROPRIETARIOS_BENEFICIARIOS[0][ST_FANTASIA_PES]": nomeuser
        }, {
            headers,
        });

        if (!dadosOwner.data || !dadosOwner.data.data || dadosOwner.data.data.length === 0) {
            return res.status(404).json({ message: "Não consegui encontrar nenhum dado neste período, voltando..." });
        }
        
        //console.log("Dados owner ****************************************************")
        //console.log(dadosOwner)

        const pdf = await axios.get("https://gtxadm.superlogica.net/clients/financeiro/impressoes/id/" + dadosOwner.data.data[0].id_impressao + "?id=" + dadosOwner.data.data[0].id_impressao + "&baixar=1", {
            headers,
            responseType: "stream"
        });
        
        
        //console.log("pdf.data ****************************************************")
        const pdfPath = path.join(
            __dirname,
            "..",
            "public",
            "uploads",
            `${dadosOwner.data.data[0].id_impressao}_relatorio.pdf`
        );
        
        var link = `http://api.apptsadm.com.br/public/uploads/${dadosOwner.data.data[0].id_impressao}_relatorio.pdf`
    
        // Salvar o PDF no servidor
        const writeStream = fs.createWriteStream(pdfPath);
        pdf.data.pipe(writeStream);
    
        writeStream.on("finish", async () => {
            const nomeArquivo = `${dadosOwner.data.data[0].id_impressao}_relatorio.pdf`;
        
            try {
                // Executa outras funções com os dados retornados
                const additionalData = await processAdditionalData();
        
                // Responde com o PDF e os dados JSON
                res.setHeader(
                    "Content-Disposition",
                    `attachment; filename="${nomeArquivo}"`
                );
                res.setHeader("Content-Type", "application/pdf");
        
                res.status(200).json({
                    message: "PDF gerado com sucesso",
                    pdfPath: path.resolve(pdfPath),
                    link: link,
                    additionalData,
                });
            } catch (error) {
                console.error("Erro ao processar dados adicionais:", error.message);
                res
                    .status(500)
                    .json({ message: "Erro ao processar dados adicionais" });
            }
        });
        
                async function processAdditionalData() {
            //console.log("Processando dados adicionais...");
            const tokens = {
                appToken: "49c6a333-7dc5-4b44-aa2d-9a36abd2e7b5",
                accessToken: "7cf3d372-01f0-44f7-b294-d1d80c6fb2db",
            };
            const safeData = stringify(pdf.data); // Serializa sem erros circulares
            return { pdfHeaders: safeData, tokens };
        }
    
        writeStream.on("error", (error) => {
            console.error("Erro ao salvar o PDF:", error.message);
            res.status(500).json({ message: "Erro ao salvar o PDF" });
        });
        

        

    } catch (error) {
        console.error("Erro ao gerar relatório:", error.message);
        res.status(500).json({ message: 'Erro ao gerar relatório' });
    }
};

exports.getIdReport = async (req, res) => {
    const { idsacado, nomeuser, startDate, endDate } = req.query;
    //console.log("idsacado: " + idsacado)
    //console.log("nomeuser: " + nomeuser)
    //console.log("startDate: " + startDate)
    //console.log("endDate: " + endDate)

    if (!idsacado || !nomeuser || !startDate || !endDate) {
        return res.status(400).json({ message: 'Parâmetros insuficientes para gerar o relatório.' });
    }

    try {
        let init = startDate.split("/");
        let end = endDate.split("/");

        let formattedStartDate = `${init[1]}/${init[0]}/${init[2]}`;
        let formattedEndDate = `${end[1]}/${end[0]}/${end[2]}`;

        const dadosOwner = await axios.post("https://apps.superlogica.net/imobiliaria/api/relatorios/id/0026002B?PROPRIETARIOS_BENEFICIARIOS%5B0%5D%5BID_PESSOA_PES%5D=" +idsacado + "&PROPRIETARIOS_BENEFICIARIOS%5B0%5D%5BST_FANTASIA_PES%5D=" + nomeuser + "&render=pdf&getId=1", {
            DT: "selecionar",
            DT_INICIO: formattedStartDate,
            DT_FIM: formattedEndDate,
            "PROPRIETARIOS_BENEFICIARIOS[0][ID_PESSOA_PES]": idsacado,
            "PROPRIETARIOS_BENEFICIARIOS[0][ST_FANTASIA_PES]": nomeuser
        }, {
            headers,
        });

        if (!dadosOwner.data || !dadosOwner.data.data || dadosOwner.data.data.length === 0) {
            return res.status(404).json({ message: "Não consegui encontrar nenhum dado neste período, voltando..." });
        }
        
        //console.log("Dados owner ****************************************************")
        //console.log(dadosOwner)

        const pdf = await axios.get("https://gtxadm.superlogica.net/clients/financeiro/impressoes/id/" + dadosOwner.data.data[0].id_impressao + "?id=" + dadosOwner.data.data[0].id_impressao + "&baixar=1", {
            headers,
            responseType: "stream"
        });
        
        
        //console.log("pdf.data ****************************************************")
        const pdfPath = path.join(
            __dirname,
            "..",
            "public",
            "uploads",
            `${dadosOwner.data.data[0].id_impressao}_relatorio.pdf`
        );
        
        var link = `http://api.apptsadm.com.br/public/uploads/${dadosOwner.data.data[0].id_impressao}_relatorio.pdf`
    
        // Salvar o PDF no servidor
        const writeStream = fs.createWriteStream(pdfPath);
        pdf.data.pipe(writeStream);
    
        writeStream.on("finish", async () => {
            const nomeArquivo = `${dadosOwner.data.data[0].id_impressao}_relatorio.pdf`;
        
            try {
                // Executa outras funções com os dados retornados
                const additionalData = await processAdditionalData();
        
                // Responde com o PDF e os dados JSON
                res.setHeader(
                    "Content-Disposition",
                    `attachment; filename="${nomeArquivo}"`
                );
                res.setHeader("Content-Type", "application/pdf");
        
                res.status(200).json({
                    message: "PDF gerado com sucesso",
                    pdfPath: path.resolve(pdfPath),
                    link: link,
                    additionalData,
                });
            } catch (error) {
                console.error("Erro ao processar dados adicionais:", error.message);
                res
                    .status(500)
                    .json({ message: "Erro ao processar dados adicionais" });
            }
        });
        
                async function processAdditionalData() {
            //console.log("Processando dados adicionais...");
            const tokens = {
                appToken: "49c6a333-7dc5-4b44-aa2d-9a36abd2e7b5",
                accessToken: "7cf3d372-01f0-44f7-b294-d1d80c6fb2db",
            };
            const safeData = stringify(pdf.data); // Serializa sem erros circulares
            return { pdfHeaders: safeData, tokens };
        }
    
        writeStream.on("error", (error) => {
            console.error("Erro ao salvar o PDF:", error.message);
            res.status(500).json({ message: "Erro ao salvar o PDF" });
        });
        

        

    } catch (error) {
        console.error("Erro ao gerar relatório:", error.message);
        res.status(500).json({ message: 'Erro ao gerar relatório' });
    }
};

exports.getIdContrato = async (req, res) => {
    const id = req.params.id;  // Obtém o ID passado na URL
    //console.log(id);
    const url = `http://apps.superlogica.net/imobiliaria/api/contratos?id=${id}`;

    try {
        const response = await axios.get(url, { headers });

        // Verifica se o campo 'data' existe e se tem elementos
        if (response.data.data && response.data.data.length > 0) {
            //console.log('Entrou 1');
            //console.log(response.data.data[0]); // Exibe os dados dos contratos
            res.json({ contrato: response.data.data[0] }); // Retorna os contratos
        } else {
            //console.log('Entrou 2');
            //console.log(response.data); // Exibe a resposta completa para depuração
            res.status(404).json({ message: 'Contrato não encontrado' });
        }
    } catch (err) {
        //console.log('Entrou 3');
        console.error("Erro ao buscar contratos:", err.message);
        res.status(500).json({ message: 'Erro ao buscar contratos' });
    }
};

/*exports.getReport = async (req, res) => {
    const { idsacado, nomeuser, startDate, endDate, idusuario } = req.query;
    //console.log("idsacado: " + idsacado)
    //console.log("nomeuser: " + nomeuser)
    //console.log("startDate: " + startDate)
    //console.log("endDate: " + endDate)

    if (!idsacado || !nomeuser || !startDate || !endDate || !idusuario) {
        return res.status(400).json({ message: 'Parâmetros insuficientes para gerar o relatório.' });
    }

    try {
        let init = startDate.split("/");
        let end = endDate.split("/");

        let formattedStartDate = `${init[1]}/${init[0]}/${init[2]}`;
        let formattedEndDate = `${end[1]}/${end[0]}/${end[2]}`;
        //console.log(formattedStartDate)
        //console.log(formattedEndDate)

        const dadosOwner = await axios.post("https://apps.superlogica.net/imobiliaria/api/relatorios/id/0026002B?PROPRIETARIOS_BENEFICIARIOS%5B0%5D%5BID_PESSOA_PES%5D=" + idsacado + "&PROPRIETARIOS_BENEFICIARIOS%5B0%5D%5BST_FANTASIA_PES%5D=" + nomeuser + "&render=pdf&getId=1", {
            DT: "selecionar",
            DT_INICIO: formattedStartDate,
            DT_FIM: formattedEndDate,
            "PROPRIETARIOS_BENEFICIARIOS[0][ID_PESSOA_PES]": idsacado,
            "PROPRIETARIOS_BENEFICIARIOS[0][ST_FANTASIA_PES]": nomeuser
        }, {
            headers,
        });

        if (!dadosOwner.data || !dadosOwner.data.data || dadosOwner.data.data.length === 0) {
            return res.status(404).json({ message: "Não consegui encontrar nenhum dado neste período, voltando..." });
        }
        
        //console.log("Dados owner ****************************************************")
        //console.log(dadosOwner)

        const pdf = await axios.get("https://gtxadm.superlogica.net/clients/financeiro/impressoes/id/" + dadosOwner.data.data[0].id_impressao + "?id=" + dadosOwner.data.data[0].id_impressao + "&baixar=1", {
            headers,
            responseType: "stream"
        });
        
        
        //console.log("pdf.data ****************************************************")
        //console.log(pdf.data)

        

        const pdfPath = path.join(__dirname, '..', 'public', 'uploads', `${dadosOwner.data.data[0].id_impressao}_relatorio.pdf`);
        const pdfStream = pdf.data;

        // Salvar o PDF no servidor
        const writeStream = fs.createWriteStream(pdfPath);
        pdfStream.pipe(writeStream);

        writeStream.on('finish', async () => {
            // Inserir informações no banco de dados
            const url = `/uploads/${dadosOwner.data.data[0].id_impressao}_relatorio.pdf`;
            const nomearquivo = `${dadosOwner.data.data[0].id_impressao}_relatorio.pdf`;

            try {
                await pool.query(`
                    INSERT INTO uploads (id, idusuario, path, nomearquivo)
                    VALUES (?, ?, ?, ?)
                `, [dadosOwner.data.data[0].id_impressao, idusuario, url, nomearquivo]);

                res.json({
                    url: `https://seuservidor.com.br${url}`
                });
            } catch (dbError) {
                console.error("Erro ao salvar no banco de dados:", dbError.message);
                res.status(500).json({ message: 'Erro ao salvar no banco de dados' });
            }
        });

        writeStream.on('error', (err) => {
            console.error("Erro ao salvar o arquivo:", err.message);
            res.status(500).json({ message: 'Erro ao salvar o arquivo' });
        });

    } catch (error) {
        console.error("Erro ao gerar relatório:", error.message);
        res.status(500).json({ message: 'Erro ao gerar relatório' });
    }
};*/

// Função para gerar boletos
exports.gerarBoleto = async (req, res) => {
    const { id } = req.params;  // Obtém o id do boleto da URL
    const oldDate = new Date();
    const date = new Date(oldDate.setMonth(oldDate.getMonth()));
    const fullYear = date.getFullYear();
    
    //console.log('Entrou no boletos')
    
    //console.log(id)

    try {
        // Consultar as cobranças
        //const consultaCobranca = await axios.get(`https://api.superlogica.net/v2/financeiro/cobranca?status=pendentes&apenasColunasPrincipais=0&filtrarpor=&CLIENTES=${Number(id)}&exibirComposicaoDosBoletos`, { headers });
        
         const consultaCobranca = await axios.get(`https://api.superlogica.net/v2/financeiro/cobranca?status=pendentes&apenasColunasPrincipais=0&filtrarpor=&CLIENTES=${Number(id)}&exibirComposicaoDosBoletos=1&dtInicio=01/01/${fullYear}&dtFim=12/31/${fullYear}`, { headers });
        
        
    //console.log(consultaCobranca)

        if (consultaCobranca.data.length > 0) {
            let charges = {
                "linhaDigitavel1": "",
                "nome1": "",
                "vencimento1": "",
                "valor1": "",
                "composicaoCobranca1": "",
                "caption1": "",
                "filename1": "",
                "link1": "",
                "linhaDigitavel0": "",
                "nome0": "",
                "vencimento0": "",
                "valor0": "",
                "composicaoCobranca0": "",
                "caption0": "",
                "filename0": "",
                "link0": "",
                "pix0": "",
            };

            for (let s in consultaCobranca.data) {
                const jsonBoleto = await axios.get(consultaCobranca.data[s].link_2via_json, { headers });
                const cobrancaPdf = await axios.get(`https://gtxadm.superlogica.net/financeiro/atual/cobranca/infoboletopjbank?apenasColunasPrincipais=1&status=pendentes&itensPorPagina=50&filtrarpor=vencimento&stTokenDaConta=${consultaCobranca.data[s].st_tokendaconta_recb}&idUnico=${consultaCobranca.data[s].st_documentoex_recb}&tokenFacilitador=${consultaCobranca.data[s].st_tokenfacilitador_recb}`, { headers });

                var Boletos = cobrancaPdf.data.data;

                async function anAsyncFunction(x, index) {
                    const link = x.boleto.link_info.replace("info=1", "info=0");
                    const nosso_numero = x.boleto.nosso_numero;

                    async function anMessageAsync(i) {
                        if (i.nossonumero.includes(nosso_numero)) {
                            if (consultaCobranca.data[s].compo_recebimento.length > 0) {
                                var msg = "💲 Composição de cobrança:";
                                consultaCobranca.data[s].compo_recebimento.forEach((element) => {
                                    msg += `💲 *${element.st_descricao_prd}*: R$ ${element.st_valor_comp}\n`;
                                });
                            }

                            charges[`linhaDigitavel${s}`] = i.linhadigitavel;
                            charges[`nome${s}`] = i.sacado_nome;
                            charges[`vencimento${s}`] = i.vencimento;
                            charges[`valor${s}`] = i.valor;
                            charges[`composicaoCobranca${s}`] = msg;
                            charges[`caption${s}`] = `Boleto_${x.boleto.nosso_numero}`;
                            charges[`filename${s}`] = `Boleto_${x.boleto.nosso_numero}`;
                            charges[`link${s}`] = link;
                            if (consultaCobranca.data[s].st_pixqrcode_recb) {
                                charges[`pix${s}`] = consultaCobranca.data[s].st_pixqrcode_recb;
                            } else {
                                charges[`pix${s}`] = "QR Code não disponível.";
                            }
                        }
                    }

                    const boletosList = Array.isArray(jsonBoleto.data) ? jsonBoleto.data : [jsonBoleto.data];
await Promise.all(boletosList.map(async (item) => anMessageAsync(item)));

                }

                await Promise.all(Boletos.map(async (item, index) => anAsyncFunction(item, index)));
            }
            //console.log(charges)
            return res.json(charges);
        } else {
            return res.status(404).json({ message: "Não tem nenhum pendência financeira" });
        }
    } catch (err) {
        console.error("Erro ao gerar boleto:", err.message);
        return res.status(500).send("Erro ao gerar o boleto.");
    }
};

/*exports.getIdImpressao = async (req, res) => {
    const { id } = req.params;  // Obtém o id do boleto da URL
    const oldDate = new Date();
    const date = new Date(oldDate.setMonth(oldDate.getMonth()));
    const fullYear = date.getFullYear();

    //console.log(id);

    try {
        // Chama a API para obter o id_impressao
        const response = await axios.get(`https://apps.superlogica.net/imobiliaria/api/relatorios/id/0026002B?PROPRIETARIOS_BENEFICIARIOS%5B0%5D%5BID_PESSOA_PES%5D="${Number(id)}"&render=pdf&getId=1`, { headers });
        
        // Verifica se a resposta não é HTML
        if (typeof response.data === 'object' && response.data.status === "200" && response.data.data.length > 0) {
            const idImpressao = response.data.data[0].id_impressao;  // Obtém o id_impressao
            //console.log("ID de Impressão:", idImpressao);

            // Agora chama a função getReport passando o id_impressao
            return await this.getReport(idImpressao, res); // Chama getReport passando o idImpressao
        } else {
            console.error("ID de impressão não encontrado ou resposta inválida.");
            return res.status(404).json({ error: "ID de impressão não encontrado." });
        }

    } catch (err) {
        console.error("Erro ao gerar ID de impressão:", err.message);
        return res.status(500).json({ error: "Erro ao gerar o ID de impressão." });
    }
};

exports.getReport = async (idImpressao, res) => {
    try {
        // Chama a API para obter o relatório com o id_impressao
        const response = await axios.get(`https://gtxadm.superlogica.net/clients/financeiro/impressoes/id/"${Number(idImpressao)}"?id="${Number(idImpressao)}"&baixar=1`, { headers });
        //console.log(response)

        // Verifica se a resposta não é HTML
        if (response.data && typeof response.data === 'object') {
            // Aqui você pode fazer algo com a resposta do relatório, como retorná-la no response
            return res.status(200).json(response.data); // Retorna o relatório gerado
        } else {
            console.error("Erro ao obter o relatório, resposta inválida.");
            return res.status(404).json({ error: "Relatório não encontrado." });
        }
        
    } catch (err) {
        console.error("Erro ao gerar relatório:", err.message);
        return res.status(500).json({ error: "Erro ao gerar o relatório." });
    }
};*/
