const pool = require('../config_db');
const moment = require('moment');


// Inicializar o Socket.IO
let io;

exports.initSocket = (socketIo) => {
    io = socketIo; // Armazenar a instância do Socket.IO
    io.on('connection', (socket) => {
        console.log('Novo cliente conectado chatController');

        socket.on('disconnect', () => {
            console.log('Cliente desconectado chatController');
        });
    });
};

function formatDateTime(dateTime) {
  const day = String(dateTime.getDate()).padStart(2, '0');
  const month = String(dateTime.getMonth() + 1).padStart(2, '0'); // O ms em JavaScript come04a do 0
  const year = dateTime.getFullYear();
  
  const hours = String(dateTime.getHours()).padStart(2, '0');
  const minutes = String(dateTime.getMinutes()).padStart(2, '0');
  const seconds = String(dateTime.getSeconds()).padStart(2, '0'); // Adicionando os segundos

  return `${day}/${month}/${year} - ${hours}:${minutes}:${seconds}`;
}

exports.renderChat = (req, res) => {
    res.render('chat');
};

exports.sender = async (req, res) => {
    
    try {
        const { id_envio, id_atendimento, id_destino, message, date, cliente, status, data_finalizado } = req.body;
        
        console.log(req.body);

        // Verificando se os campos obrigatrios est00o presentes
        if (!id_envio || !id_destino || !message) {
            return res.status(400).json({ message: 'Todos os campos s00o obrigatrios.' });
        }

        // Inserir a mensagem no banco de dados
        const [result] = await pool.execute(
            'INSERT INTO chat (id_envio, id_destino, mensagem, date, id_atendimento) VALUES (?, ?, ?, ?, ?)',
            [id_envio, id_destino, message, date, id_atendimento]
        );
        
        // Atualizando a data do atendimento no formato desejado
            const updateDate = new Date();
            const formattedDate = formatDateTime(updateDate);
            const dataFormatada = moment(formattedDate, "DD/MM/YYYY - HH:mm:ss").format("YYYY-MM-DD HH:mm:ss");

            var updateQuery = `
                UPDATE atendimento
                SET status = ?, atualizado_em = ?
                WHERE id = ?
            `;

        // Verificando se o campo cliente foi fornecido para atualizar o status no atendimento
         if (cliente) {
            console.log('Enviou mensagem como: ' + cliente)
            // Atualizando o status e a data de atualiza0400o do atendimento
            const [updateResult] = await pool.execute(updateQuery, [cliente, dataFormatada, id_atendimento]);
        }
        if(status){
            console.log('Enviou mensagem como: ' + status)
            if(data_finalizado){
                updateQuery = `
                    UPDATE atendimento
                    SET status = ?, atualizado_em = ?, data_finalizado = ?
                    WHERE id = ?
                `;
                // Atualizando o status e a data de atualiza0400o do atendimento
                const [updateResult] = await pool.execute(updateQuery, [status, dataFormatada, data_finalizado, id_atendimento]);
            }else{
                // Atualizando o status e a data de atualiza0400o do atendimento
            const [updateResult] = await pool.execute(updateQuery, [status, dataFormatada, id_atendimento]);
            }
            
        }

        // Emitir a mensagem para todos os clientes conectados
        io.emit('novaMensagem', { id_envio, id_destino, message, date, id_atendimento });

        return res.status(200).json({ message: 'Mensagem enviada com sucesso.' });
    } catch (error) {
        console.error('Erro ao enviar mensagem:', error);
        return res.status(500).json({ message: 'Erro interno do servidor.' });
    }
};

exports.iniciarAtendimento = async (req, res) => {
    //console.log("Acessou atendimento");
    try {
        const { status, email, data_iniciado, setor } = req.body;
        
        if (!status || !email || !data_iniciado) {
            return res.status(400).json({ message: 'Todos os campos s00o obrigatrios.' });
        }

        const [result] = await pool.execute(
            'INSERT INTO atendimento (status, email, data_iniciado, setor, atualizado_em) VALUES (?, ?, ?, ?, ?)',
            [status, email, data_iniciado, setor, data_iniciado]
        );

        // Retornando o ID do atendimento recm-criado
        return res.status(200).json({ 
            message: 'Atendimento iniciado com sucesso.',
            id_atendimento: result.insertId,
            data_iniciado: data_iniciado
        });
    } catch (error) {
        console.error('Erro ao iniciar atendimento:', error);
        return res.status(500).json({ message: 'Erro interno do servidor.' });
    }
};

exports.getMensagem = async (req, res) => {
    const { id } = req.params;

    const query = `
        SELECT * FROM chat
        WHERE id_envio = ? OR id_destino = ?
        ORDER BY date ASC
    `;

    try {
        const [results] = await pool.query(query, [id, id]);
        res.json({ chat: results });
    } catch (err) {
        console.error("Erro ao buscar mensagens:", err.message);
        res.status(500).send("Erro ao buscar mensagens.");
    }
};

exports.getAtendimento = async (req, res) => {
    const { email } = req.params;

    /*const query = `
        SELECT * FROM atendimento
        WHERE email = ? AND status != 'Finalizado'
    `;*/
    const query = `
        SELECT * FROM atendimento
        WHERE email = ?`;

    try {
        const [results] = await pool.query(query, [email]);
        console.log(results)

        res.json({ atendimento: results });
    } catch (err) {
        console.error("Erro ao buscar atendimento:", err.message);
        res.status(500).send("Erro ao buscar atendimento.");
    }
};


exports.getAllAtendimentos = async (req, res) => {
    //console.log('Entrou aqui')
    const query = `SELECT * FROM atendimento ORDER BY data_iniciado ASC`;

    try {
        const [results] = await pool.query(query);
        //console.log(results);
        res.json({ atendimentos: results.length > 0 ? results : [] }); // Garante que sempre retorna um array
    } catch (err) {
        console.error("Erro ao buscar atendimentos:", err.message);
        res.status(500).json({ error: "Erro ao buscar atendimentos.", atendimentos: [] }); // Retorna array vazio
    }
};

exports.avaliarAtendimento = async (req, res) => {
    //console.log("Acessou atendimento");
    try {
        const { id, avaliacao } = req.body;
        const updateDate = new Date();
        const formattedDate = formatDateTime(updateDate);
        const dataFormatada = moment(formattedDate, "DD/MM/YYYY - HH:mm:ss").format("YYYY-MM-DD HH:mm:ss");
        
        if (!avaliacao) {
            return res.status(400).json({ message: 'Avalia0400o  obrigatria.' });
        }
        
        updateQuery = `
            UPDATE atendimento
            SET atualizado_em = ?, avaliado = ?, avaliacao = ?
            WHERE id = ?
        `;
        // Atualizando o status e a data de atualiza0400o do atendimento
        const [updateResult] = await pool.execute(updateQuery, [dataFormatada, 1, avaliacao, id]);


        // Retornando o ID do atendimento recm-criado
        return res.status(200).json({ 
            message: 'Avaliado com sucesso.',
            id_atendimento: updateResult.insertId,
        });
    } catch (error) {
        console.error('Erro ao iniciar atendimento:', error);
        return res.status(500).json({ message: 'Erro interno do servidor.' });
    }
};

