const pool = require('../config_db');


exports.renderImoveis = (req, res) => {
    res.render('imoveis');
};

// Função para obter todos os anúncios com todas as informações
exports.getAllImoveis = async (req, res) => {
    console.log('Entrou no all imoveis')
    const query = `
        SELECT 
            i.*, 
            u.id AS usuario_id, u.nomeCompleto AS usuario_nome, u.cpf, u.email, u.dataNasc, 
            u.celular, u.rg, u.orgaoRg, u.nacionalidade, u.profissao, 
            u.estadoCivil, u.sexo,
            GROUP_CONCAT(DISTINCT ic.caracteristica_id ORDER BY ic.caracteristica_id SEPARATOR ', ') AS caracteristicas,
            GROUP_CONCAT(DISTINCT icc.caracteristica_id ORDER BY icc.caracteristica_id SEPARATOR ', ') AS caracteristicas_condominio,
            GROUP_CONCAT(DISTINCT img.link ORDER BY img.id SEPARATOR ', ') AS imagens
        FROM imoveis i
        JOIN usuarios u ON i.id_usuario = u.id
        LEFT JOIN imovel_caracteristicas ic ON i.id = ic.imovel_id
        LEFT JOIN imovel_caracteristicas_condominio icc ON i.id = icc.imovel_id
        LEFT JOIN imagens_imovel img ON i.id = img.id_imovel
        WHERE i.disponibilidade IN ('Reprovado', 'Aprovado Site', 'Aprovado Zap', 'Aprovado Site/Zap')  -- Adiciona a condição de filtro
        GROUP BY i.id, u.id
        ORDER BY i.id DESC`;

    try {
        // Usa o método `promise().query()` para trabalhar com Promises
        const [results] = await pool.query(query);
        //console.log(results)
        res.json({ imoveis: results });

    } catch (err) {
        console.error("Erro ao buscar anúncios:", err.message);
        res.status(500).send("Erro ao buscar os anúncios.");
    }
};

/*const CANAL_PRO_API_URL = 'https://api.canalpro.com.br/imoveis'; // Substitua pela URL correta
const API_KEY = 'SUA_CHAVE_DE_API_AQUI'; // Substitua pela sua chave de API

exports.enviarImoveisParaCanalPro = async (req, res) => {
    const query = `
        SELECT 
            i.*, 
            u.id AS usuario_id, u.nomeCompleto AS usuario_nome, u.email, u.celular,
            GROUP_CONCAT(DISTINCT ic.caracteristica_id ORDER BY ic.caracteristica_id SEPARATOR ', ') AS caracteristicas,
            GROUP_CONCAT(DISTINCT img.link ORDER BY img.id SEPARATOR ', ') AS imagens
        FROM imoveis i
        JOIN usuarios u ON i.id_usuario = u.id
        LEFT JOIN imovel_caracteristicas ic ON i.id = ic.imovel_id
        LEFT JOIN imagens_imovel img ON i.id = img.id_imovel
        WHERE i.disponibilidade IN ('Aprovado Zap', 'Aprovado Site/Zap') 
        GROUP BY i.id, u.id
        ORDER BY i.id DESC
    `;

    try {
        const [imoveis] = await pool.query(query);

        if (imoveis.length === 0) {
            return res.json({ message: "Nenhum imóvel disponível para envio." });
        }

        for (const imovel of imoveis) {
            const payload = {
                codigo: imovel.id,
                titulo: imovel.titulo,
                descricao: imovel.descricao,
                preco: imovel.preco,
                tipo: imovel.tipo,
                endereco: imovel.endereco,
                cidade: imovel.cidade,
                estado: imovel.estado,
                cep: imovel.cep,
                latitude: imovel.latitude,
                longitude: imovel.longitude,
                caracteristicas: imovel.caracteristicas ? imovel.caracteristicas.split(', ') : [],
                imagens: imovel.imagens ? imovel.imagens.split(', ') : [],
                proprietario: {
                    nome: imovel.usuario_nome,
                    email: imovel.email,
                    telefone: imovel.celular
                }
            };

            try {
                const response = await axios.post(CANAL_PRO_API_URL, payload, {
                    headers: {
                        'Content-Type': 'application/json',
                        'Authorization': `Bearer ${API_KEY}`
                    }
                });

                console.log(`Imóvel ${imovel.id} enviado com sucesso:`, response.data);
            } catch (error) {
                console.error(`Erro ao enviar imóvel ${imovel.id}:`, error.response?.data || error.message);
            }
        }

        res.json({ message: "Processo concluído! Verifique os logs para mais detalhes." });

    } catch (err) {
        console.error("Erro ao buscar imóveis:", err.message);
        res.status(500).send("Erro ao buscar os imóveis.");
    }
};*/



