document.addEventListener("DOMContentLoaded", async () => {
    function converterDataParaBrasil(dataISO) {
        if (dataISO.includes('/')) return dataISO;
        if (!dataISO) return "";
        
        const partes = dataISO.split("-");
        if (partes.length !== 3) return "Formato inválido";
    
        const [ano, mes, dia] = partes;
        return `${dia}/${mes}/${ano}`;
    }
    

    if(document.getElementById('aluguelExpressTable')){
        try {            
            const response = await fetch(`http://api.apptsadm.com.br:3003/aluguel/express/listar`);
            const data = await response.json();
    
            if (!data.erro) {  
                //console.log(data)          
                const aluguelExpressTable = document.getElementById('aluguelExpressTable');
                const statusFilter = document.getElementById('statusFilter');
                aluguelExpressTable.innerHTML = ''; // Limpa o conteúdo atual da tabela
                
                
                const coresDisponibilidade = {
                    "Pendente": "yellow",
                    "Aprovado": "green",
                    "Rejeitado": "red"
                };
                
    
                // Preenche a tabela com os anúncios recebidos
                data.solicitacoes.forEach(aluguel => {
                    
                    const cor = coresDisponibilidade[aluguel.status] || "red";
                    const row = document.createElement('tr');
                    row.setAttribute('data-status', aluguel.status);

                    row.innerHTML = `
                        <td><a href='/aluguel/express/ver/${aluguel.id}'>${aluguel.tituloImovel}</a></td>
                        <td>${aluguel.nomeCompleto}</td>
                        <td>${aluguel.celular}</td>
                        <td>${aluguel.email}</td>
                        <td>${aluguel.garantia}</td>
                        <td>R$ ${aluguel.valorProposta}</td>
                        <td><span style='color:${cor}'>${aluguel.status}</span></td>
                    `;                 
                    
                    aluguelExpressTable.appendChild(row);
                });
                
                statusFilter.addEventListener('change', () => {
                    const selectedStatus = statusFilter.value;
            
                    // Itera sobre as linhas da tabela e exibe/oculta conforme o status
                    Array.from(aluguelExpressTable.rows).forEach(row => {
                        const rowStatus = row.getAttribute('data-status');
                        if (selectedStatus === 'all' || rowStatus === selectedStatus) {
                            row.style.display = '';
                        } else {
                            row.style.display = 'none';
                        }
                    });
                });
            
                // Ordenação por coluna
                const headers = aluguelExpressTable.querySelectorAll('.sortable');
                headers.forEach(header => {
                    header.addEventListener('click', () => {
                        const column = Array.from(headers).indexOf(header);
                        const rows = Array.from(tbody.rows);
            
                        // Alterna entre ascendente e descendente
                        const isAscending = header.classList.toggle('asc');
                        header.classList.toggle('desc', !isAscending);
            
                        // Ordena as linhas
                        rows.sort((a, b) => {
                            const aText = a.cells[column].textContent.trim();
                            const bText = b.cells[column].textContent.trim();
                            return isAscending ? aText.localeCompare(bText) : bText.localeCompare(aText);
                        });
            
                        // Reanexa as linhas na nova ordem
                        rows.forEach(row => tbody.appendChild(row));
                    });
                });
                
                
            } else {
                console.log(data);
                alert('Não há dados para exibir.');
            }
        } catch (error) {
            console.error('Erro ao buscar dados:', error);
            alert('Ocorreu um erro ao buscar dados.');
        }
    }
    
    if(document.getElementById('dadosAluguelExpress')){
        const urlParts = window.location.pathname.split('/');
        const id = urlParts[urlParts.length - 1]; 

        try {          
            const response = await fetch(`http://api.apptsadm.com.br:3003/aluguel/express/${id}`);
            const data = await response.json();
    
            if (!data.erro) {  
                //console.log(data)  
                const tituloImovel = document.getElementById('tituloImovel');
                const linkImovel = document.getElementById('linkImovel');
                const botoesAluguel = document.getElementById('botoesAluguel');
                tituloImovel.innerHTML = data.tituloImovel
                linkImovel.innerHTML = `<a href="/anuncio/ver/${data.id_imovel}">Ver imóvel</a>`
                
                if(data.status == 'Pendente'){                    
                    tituloImovel.innerHTML += `<br><span style='color:yellow'>${data.status}</span>`
                    botoesAluguel.innerHTML = `
                    <a href="/aluguel/aprovar/${data.id}" class="btn btn-success">Aprovar</a>
                    <a href="/aluguel/reprovar/${data.id}" class="btn btn-warning">Reprovar</a>
                    `;                    
                }else if(data.status == 'Aprovado'){                    
                    tituloImovel.innerHTML +=  `<br><span style='color:green'>${data.status}</span>`
                    botoesAluguel.innerHTML = `
                    <a href="/aluguel/pendente/${data.id}" class="btn btn-alert">Pendente</a>
                    <a href="/aluguel/reprovar/${data.id}" class="btn btn-warning">Reprovar</a>
                    `;                    
                }else{
                    tituloImovel.innerHTML += `<br><span style='color:red'>${data.status}</span>`
                    botoesAluguel.innerHTML = `
                    <a href="/aluguel/aprovar/${data.id}" class="btn btn-success">Aprovar</a>
                    <a href="/aluguel/pendente/${data.id}" class="btn btn-alert">Pendente</a>
                    `;  
                }
                
                
                var dadosAluguelExpress = document.getElementById('dadosAluguelExpress');
                dadosAluguelExpress.innerHTML += `<p class='texto'>
                <b>Solicitante:</b> ${data.nomeCompleto}<br>
                <b>Email:</b> ${data.email}<br>
                <b>Celular:</b> ${data.celular}<br>
                <b>Tipo de garantia:</b> ${data.garantia}</p><br>
                `
                if(data.garantia == 'Fiador(a)'){
                   dadosAluguelExpress.innerHTML += `
                    <h4>Informações do fiador(a)</h4>
                    
                    <p class='texto'><b>Nome:</b> ${data.nomeFiador}<br>
                    <b>Email:</b>  ${data.emailFiador}<br>
                    <b>Celular:</b>  ${data.celularFiador}<br>
                    <b>Data de Nascimento:</b>  ${converterDataParaBrasil(data.dataNascFiador)}<br>
                    <b>CPF:</b>  ${data.cpfFiador}<br>
                    <b>RG:</b>  ${data.rgFiador} - <b>Órgão Expedidor:</b>  ${data.orgaoFiador}<br>
                    <b>Nacionalidade:</b>  ${data.nacionalidadeFiador}<br>
                    <b>Profissão:</b>  ${data.profissaoFiador}<br>
                    <b>Sexo:</b>  ${data.sexoFiador}<br>
                    <b>Estado Civil:</b>  ${data.estadoCivilFiador}</p><br>
                    
                    <h4>Endereço do fiador(a)</h4>
                    
                    <p class='texto'>
                    ${data.logradouroFiador}, ${data.numeroFiador}</p>
                    ` 
                    if(data.complementoFiador){
                      dadosAluguelExpress.innerHTML += `<p class='texto'><b>Complemento:</b>  ${data.complementoFiador}</p>` 
                    }
                    dadosAluguelExpress.innerHTML += `<p class='texto'>${data.bairroFiador} - ${data.cidadeFiador}/${data.estadoFiador}<br>
                    <b>CEP:</b>  ${data.cepFiador}</p><br>` 
                    
                    if(data.estadoCivilFiador == 'Casado(a)'){
                      dadosAluguelExpress.innerHTML += `
                    <h4>Informações do(a) cônjuge do(a) fiador(a)</h4>
                    
                    <p class='texto'><b>Nome do(a) cônjuge:</b> ${data.nomeConjugeFiador}<br>
                    <b>Celular do(a) cônjuge:</b>  ${data.celularConjugeFiador}<br>
                    <b>Data de Nascimento do(a) cônjuge:</b>  ${converterDataParaBrasil(data.dataNascConjugeFiador)}<br>
                    <b>CPF do(a) cônjuge:</b>  ${data.cpfConjugeFiador}<br>
                    <b>RG do(a) cônjuge:</b>  ${data.rgFiador} - <b>Órgão Expedidor:</b>  ${data.orgaoConjugeFiador}<br>
                    <b>Nacionalidade do(a) cônjuge:</b>  ${data.nacionalidadeConjugeFiador}<br>
                    <b>Profissão do(a) cônjuge:</b>  ${data.profissaoConjugeFiador}<br><br>
                    ` 
                    }
                    
                    
                    if(data.cepImovelGarantia){
                        dadosAluguelExpress.innerHTML += `<h4>Endereço do Imóvel como garantia</h4>
                    <p class='texto'>
                    ${data.logradouroImovelGarantia}, ${data.numeroImovelGarantia}</p>`
                    
                        if(data.complementoImovelGarantia){
                            dadosAluguelExpress.innerHTML += `<p class='texto'><b>Complemento:</b>  ${data.complementoImovelGarantia}</p>`
                        }
                        
                        dadosAluguelExpress.innerHTML += `<p class='texto'>${data.bairroImovelGarantia} - ${data.cidadeImovelGarantia}/${data.estadoImovelGarantia}<br>
                        <b>CEP:</b>  ${data.cepImovelGarantia}</p><br>`
                    
                       
                    }
                    
                    
                    
                    //dadosAluguelExpress.innerHTML += `<p class='texto'><b>Valor Ônus Real Imóvel como garantia:</b> R$ ${data.valorOnusImovel}</p>`
                    
                }
                
                dadosAluguelExpress.innerHTML += `<p class='texto'><b>Valor da proposta:</b> R$ ${data.valorProposta}</p><br>`
                
                if (data.documentos && data.documentos.length > 0) {
                const documentosList = document.createElement("ul");
                data.documentos.forEach(doc => {
                    if(doc.tipo == 'docFrente'){
                        dadosAluguelExpress.innerHTML += `
                    <p><strong>Documento Frente</strong></p>
                  `;
                    }
                    if(doc.tipo == 'documentoVerso'){
                        dadosAluguelExpress.innerHTML += `
                    <p><strong>Documento Verso</strong></p>
                  `;
                    }
                    if(doc.tipo == 'comprovanteRenda1'){
                        dadosAluguelExpress.innerHTML += `
                    <p><strong>Comprovante de renda 1 - Locatário(a)</strong></p>
                  `;
                    }
                    if(doc.tipo == 'comprovanteRenda2'){
                        dadosAluguelExpress.innerHTML += `
                    <p><strong>Comprovante de renda 2 - Locatário(a)</strong></p>
                  `;
                    }
                    if(doc.tipo == 'comprovanteRenda3'){
                        dadosAluguelExpress.innerHTML += `
                    <p><strong>Comprovante de renda 3 - Locatário(a)</strong></p>
                  `;
                    }
                    if(doc.tipo == 'comprovanteRendaFiador1'){
                        dadosAluguelExpress.innerHTML += `
                    <p><strong>Comprovante de renda 1 - Fiador(a)</strong></p>
                  `;
                    }
                    if(doc.tipo == 'comprovanteRendaFiador2'){
                        dadosAluguelExpress.innerHTML += `
                    <p><strong>Comprovante de renda 2 - Fiador(a)</strong></p>
                  `;
                    }
                    if(doc.tipo == 'comprovanteRendaFiador3'){
                        dadosAluguelExpress.innerHTML += `
                    <p><strong>Comprovante de renda 3 - Fiador(a)</strong></p>
                  `;
                    }
                    if(doc.tipo == 'comprovanteEndereco'){
                        dadosAluguelExpress.innerHTML += `
                    <p><strong>Comprovante de endereço</strong></p>
                  `;
                    }
                    
                    if(doc.tipo == 'declaracaoImpostoLocatario'){
                        dadosAluguelExpress.innerHTML += `
                    <p><strong>Declaração Imposto de Renda Locatário(a)</strong></p>
                  `;
                    }
                    
                    if(doc.tipo == 'declaracaoImpostoFiador'){
                        dadosAluguelExpress.innerHTML += `
                    <p><strong>Declaração Imposto de Renda Fiador(a)</strong></p>
                  `;
                    }
                    
                    if(doc.tipo == 'comprovanteRendimentoLocatario'){
                        dadosAluguelExpress.innerHTML += `
                    <p><strong>Comprovante rendimento Locatário(a)</strong></p>
                  `;
                    }
                    
                    if(doc.tipo == 'comprovanteRendimentoFiador'){
                        dadosAluguelExpress.innerHTML += `
                    <p><strong>Comprovante Rendimento Fiador(a)</strong></p>
                  `;
                    }
                    
                    if(doc.tipo == 'onusReais'){
                        dadosAluguelExpress.innerHTML += `
                    <p><strong>Ônus Reais do Imóvel</strong></p>
                  `;
                    }
                  dadosAluguelExpress.innerHTML += `
                    <p><strong></strong> <a href='https://api.apptsadm.com.br/${doc.caminho}' target='_blank'>${doc.nome}</a></p><br>
                  `;
                });
              } else {
                dadosAluguelExpress.innerHTML += "<p>Nenhum documento encontrado.</p>";
              }
    
     	
                /*
                	 	 		 	
     	 	 	 	 	 	 	 
     	
                const disponibilidadeImovel = document.getElementById('disponibilidadeImovel');
                var dadosAnuncio = document.getElementById('dadosAnuncio');
                const botoesImovel = document.getElementById('botoesImovel');

                tituloImovel.innerHTML = `${data.tituloImovel}`;
                if(data.disponibilidade == 'Pendente'){                    
                    disponibilidadeImovel.innerHTML = `<span style='color:yellow'>${data.disponibilidade}</span>`
                    botoesImovel.innerHTML = `
                    <a href="/anuncio/aprovar/${data.id}" class="btn btn-success">Aprovar</a>
                    <a href="/anuncio/reprovar/${data.id}" class="btn btn-warning">Reprovar</a>
                    `;                    
                }else if(data.disponibilidade == 'Aprovado'){                    
                    disponibilidadeImovel.innerHTML = `<span style='color:green'>${data.disponibilidade}</span>`
                    botoesImovel.innerHTML = `
                    <a href="/anuncio/pendente/${data.id}" class="btn btn-alert">Pendente</a>
                    <a href="/anuncio/reprovar/${data.id}" class="btn btn-warning">Reprovar</a>
                    `;                    
                }else{
                    disponibilidadeImovel.innerHTML = `<span style='color:red'>${data.disponibilidade}</span>`
                    botoesImovel.innerHTML = `
                    <a href="/anuncio/aprovar/${data.id}" class="btn btn-success">Aprovar</a>
                    <a href="/anuncio/pendente/${data.id}" class="btn btn-alert">Pendente</a>
                    `; 
                }
                
                
                dadosAnuncio.innerHTML = `
                <p class='text'>${data.relacao}: ${data.nomeCompleto}</p>                
                `;

                if(data.celular){
                    dadosAnuncio.innerHTML += `<p class='text'>Telefone responsável: ${data.celular}</p><br>`;
                }else{
                    dadosAnuncio.innerHTML += `<p class='text'>Telefone responsável: Não preencheu</p><br>`;
                }

                if(data.descricaoImovel){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Descrição do imóvel</span>: ${data.descricaoImovel}</p>`;
                }else{
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Descrição do imóvel</span>: Não preencheu</p>`;
                }

                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Tipo de imóvel</span>: ${data.tipoImovel}</p>`;

                if(data.area){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Área do imóvel</span>: ${data.area}m²</p>`;
                }else{
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Área do imóvel</span>: Não preencheu</p>`;
                }

                

                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Quartos</span>: ${data.quartos}</p>`;
                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Suítes</span>: ${data.suites}</p>`;
                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Salas</span>: ${data.salas}</p>`;
                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Banheiros</span>: ${data.banheiros}</p>`;
                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Vagas</span>: ${data.vagas}</p>`;
                dadosAnuncio.innerHTML += `<br>`;
                
                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Endereço</span>: <br>${data.logradouro}, ${data.numero}</p>`;
                if(data.complemento){                    
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Complemento:</span> ${data.complemento}</p>`;
                }
                dadosAnuncio.innerHTML += `<p class='text'>${data.bairro} - ${data.cidade}/${data.estado}</p>`;
                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>CEP:</span> ${data.cep}</p>`;
                dadosAnuncio.innerHTML += `<br>`;

                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Status do Imóvel</span>: ${data.status}</p>`;

                if(data.status == 'Aluguel'){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Valor do aluguel</span>: R$ ${data.valorAluguel}</p>`;
                }else if(data.status == 'Venda'){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Valor da venda</span>: R$ ${data.valorVenda}</p>`;
                }else{
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Valor do aluguel</span>: R$ ${data.valorAluguel}</p>`;
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Valor da venda</span>: R$ ${data.valorVenda}</p>`;
                }

                if(data.valorIptu){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Valor do IPTU</span>: R$ ${data.valorIptu}</p>`;
                }

                
                dadosAnuncio.innerHTML += `<br>`;

                if(data.nomeCondominio){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Nome do Condomínio</span>: ${data.nomeCondominio}</p>`;
                }

                if(data.valorCondominio){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Valor do Condomínio</span>: R$ ${data.valorCondominio}</p>`;                    
                    dadosAnuncio.innerHTML += `<br>`;
                }

                */

            } else {
                console.log(data);
                alert('Não há dados para exibir.');
            }
        } catch (error) {
            console.error('Erro ao buscar dados:', error);
            alert('Ocorreu um erro ao buscar dados.');
        }
    }
})