document.addEventListener("DOMContentLoaded", async () => {

    if(document.getElementById('dadosAnuncio')){
        const urlParts = window.location.pathname.split('/');
        const id = urlParts[urlParts.length - 1]; 

        try {            
            const response = await fetch(`http://api.apptsadm.com.br:3003/anuncio/${id}`);
            const data = await response.json();
    
            if (!data.erro) {  
                console.log(data)          
                const tituloImovel = document.getElementById('tituloImovel');
                const disponibilidadeImovel = document.getElementById('disponibilidadeImovel');
                var dadosAnuncio = document.getElementById('dadosAnuncio');
                var imagensAnuncio = document.getElementById('imagensAnuncio');
                const botoesImovel = document.getElementById('botoesImovel');
                

                // Converter para array
                const arrayImagens = data.imagens.split(",");
                
                // Percorrer o array
                arrayImagens.forEach((img, index) => {
                    imagensAnuncio.innerHTML += `<div class='col-12 col-sm-6' style='margin-bottom: 15px'><a href='http://api.apptsadm.com.br/public/${img}' target='_blank'><img class='imagemAnuncio' src='http://api.apptsadm.com.br/public/${img}'></a></div>`;
                });

                tituloImovel.innerHTML = `${data.tituloImovel}`;
                if(data.disponibilidade == 'Pendente'){                    
                    disponibilidadeImovel.innerHTML = `<span style='color:yellow'>${data.disponibilidade}</span>`
                    botoesImovel.innerHTML = `
                    <a href="/anuncio/aprovar/site/${data.id}" class="btn btn-success">Aprovar Site</a>
                    <a href="/anuncio/aprovar/zap/${data.id}" class="btn btn-success">Aprovar Zap</a>
                    <a href="/anuncio/aprovar/site/zap/${data.id}" class="btn btn-success">Aprovar Site/Zap</a>
                    <a href="/anuncio/reprovar/${data.id}" class="btn btn-warning">Reprovar</a>
                    `;                    
                }else if(data.disponibilidade == 'Aprovado Site' || data.disponibilidade == 'Aprovado Zap' || data.disponibilidade == 'Aprovado Site/Zap'){                    
                    disponibilidadeImovel.innerHTML = `<span style='color:green'>${data.disponibilidade}</span>`
                    botoesImovel.innerHTML = `
                    <a href="/anuncio/pendente/${data.id}" class="btn btn-alert">Pendente</a>
                    <a href="/anuncio/reprovar/${data.id}" class="btn btn-warning">Reprovar</a>
                    `;                    
                }else{
                    disponibilidadeImovel.innerHTML = `<span style='color:red'>${data.disponibilidade}</span>`
                    botoesImovel.innerHTML = `
                    <a href="/anuncio/aprovar/site/${data.id}" class="btn btn-success">Aprovar Site</a>
                    <a href="/anuncio/aprovar/zap/${data.id}" class="btn btn-success">Aprovar Zap</a>
                    <a href="/anuncio/aprovar/site/zap/${data.id}" class="btn btn-success">Aprovar Site/Zap</a>
                    <a href="/anuncio/pendente/${data.id}" class="btn btn-alert">Pendente</a>
                    `; 
                }
                
                
                dadosAnuncio.innerHTML = `
                <p class='text'>${data.relacao}: ${data.nomeCompleto}</p>                
                `;

                if(data.celular){
                    dadosAnuncio.innerHTML += `<p class='text'>Telefone responsável: ${data.celular}</p><br>`;
                }else{
                    dadosAnuncio.innerHTML += `<p class='text'>Telefone responsável: Não preencheu</p><br>`;
                }

                if(data.descricaoImovel){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Descrição do imóvel</span>: ${data.descricaoImovel}</p>`;
                }else{
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Descrição do imóvel</span>: Não preencheu</p>`;
                }

                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Tipo de imóvel</span>: ${data.tipoImovel}</p>`;

                if(data.area){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Área do imóvel</span>: ${data.area}m²</p>`;
                }else{
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Área do imóvel</span>: Não preencheu</p>`;
                }

                

                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Quartos</span>: ${data.quartos}</p>`;
                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Suítes</span>: ${data.suites}</p>`;
                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Salas</span>: ${data.salas}</p>`;
                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Banheiros</span>: ${data.banheiros}</p>`;
                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Vagas</span>: ${data.vagas}</p>`;
                dadosAnuncio.innerHTML += `<br>`;
                
                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Endereço</span>: <br>${data.logradouro}, ${data.numero}</p>`;
                if(data.complemento){                    
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Complemento:</span> ${data.complemento}</p>`;
                }
                dadosAnuncio.innerHTML += `<p class='text'>${data.bairro} - ${data.cidade}/${data.estado}</p>`;
                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>CEP:</span> ${data.cep}</p>`;
                dadosAnuncio.innerHTML += `<br>`;

                dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Status do Imóvel</span>: ${data.status}</p>`;

                if(data.status == 'Aluguel'){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Valor do aluguel</span>: R$ ${data.valorAluguel}</p>`;
                }else if(data.status == 'Venda'){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Valor da venda</span>: R$ ${data.valorVenda}</p>`;
                }else{
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Valor do aluguel</span>: R$ ${data.valorAluguel}</p>`;
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Valor da venda</span>: R$ ${data.valorVenda}</p>`;
                }

                if(data.valorIptu){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Valor do IPTU</span>: R$ ${data.valorIptu}</p>`;
                }

                
                dadosAnuncio.innerHTML += `<br>`;

                if(data.nomeCondominio){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Nome do Condomínio</span>: ${data.nomeCondominio}</p>`;
                }

                if(data.valorCondominio){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Valor do Condomínio</span>: R$ ${data.valorCondominio}</p>`;                    
                    dadosAnuncio.innerHTML += `<br>`;
                }

                if(data.aceitaFiador){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Aceita Fiador(a)</span>: Sim</p>`;
                }else{
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Aceita Fiador(a)</span>: Não</p>`;
                }

                if(data.aceitaDeposito){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Aceita Deposito Caução</span>: Sim</p>`;
                }else{
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Aceita Deposito Caução</span>: Não</p>`;
                }

                if(data.aceitaSeguro){
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Aceita Seguro Fiança</span>: Sim</p>`;
                }else{
                    dadosAnuncio.innerHTML += `<p class='text'><span class='title'>Aceita Seguro Fiança</span>: Não</p>`;
                }
                
                console.log(data.caracteristicas)

                if(data.caracteristicas.length > 0){
                    dadosAnuncio.innerHTML += `<div style='margin-top:20px'><h4 style='color:#fff'>Características do Imóvel</h4>`
                    data.caracteristicas.forEach(caracteristica => {
                        //console.log('Caracteristicas: ' + caracteristica);
                        if(caracteristica == 'piscina'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">Piscina</span>
                            </div>`
                        }
        
                        if(caracteristica == 'mobiliado'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">Mobiliado</span>
                            </div>`
                        }
        
                        if(caracteristica == 'varandaGourmet'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">Varanda Gourmet</span>
                            </div>`
                        }
        
                        if(caracteristica == 'lareira'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">Lareira</span>
                            </div>`
                        }
        
                        if(caracteristica == 'jardimInverno'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">Jardim de Inverno</span>
                            </div>`
                        }
        
                        if(caracteristica == 'homeTheater'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">HomeTheater</span>
                            </div>`
                        }
        
                        if(caracteristica == 'cozinhaPlanejada'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">Cozinha Planejada</span>
                            </div>`
                        }
        
                        if(caracteristica == 'cozinhaAmericana'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">Cozinha Americana</span>
                            </div>`
                        }
        
                        if(caracteristica == 'closet'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">Closet</span>
                            </div>`
                        }
        
                        if(caracteristica == 'arCondicionado'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">Ar Condicionado</span>
                            </div>`
                        }
        
                        if(caracteristica == 'varanda'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">Varanda</span>
                            </div>`
                        }
        
                        if(caracteristica == 'tvCabo'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">TV a Cabo</span>
                            </div>`
                        }
        
                        if(caracteristica == 'vistaMar'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">Vista para o Mar</span>
                            </div>`
                        }
        
                        if(caracteristica == 'academia'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">Academia</span>
                            </div>`
                        }
                        if(caracteristica == 'sauna'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">Sauna</span>
                            </div>`
                        }
        
                        if(caracteristica == 'aceitaAnimais'){
                            dadosAnuncio.innerHTML += 
                            `<div style='color:#fff'>
                            <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                            </i><span class="texto">Aceita animais</span>
                            </div>`
                        }   
                        
                        
                        
        
                    });
                    dadosAnuncio.innerHTML += 
                            `</div>`
                }
    
                if(data.caracteristicas_condominio.length > 0){
                    dadosAnuncio.innerHTML += `<div style='margin-top:20px'><h4 style='color:#fff'>Características do Condomínio</h4>`
                    data.caracteristicas_condominio.forEach(caracteristica => {
                        //console.log('Caracteristicas condominio: ' + caracteristica);
                        if(caracteristica == 'lavanderia'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Lavanderia</span>
                                </div>`
                            }
            
                            if(caracteristica == 'bicicletario'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Bicicletário</span>
                                </div>`
                            }
            
                            if(caracteristica == 'churrasqueira'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Churrasqueira</span>
                                </div>`
                            }
            
                            if(caracteristica == 'espacoGourmet'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Espaço Gourmet</span>
                                </div>`
                            }
            
                            if(caracteristica == 'quadraSquash'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Quadra Squash</span>
                                </div>`
                            }
            
                            if(caracteristica == 'quadraTenis'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Quadra Tênis</span>
                                </div>`
                            }
            
                            if(caracteristica == 'quadraPoliesportiva'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Quadra Poliesportiva</span>
                                </div>`
                            }
            
                            if(caracteristica == 'salaoFestas'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Salão de Festas</span>
                                </div>`
                            }
            
                            if(caracteristica == 'salaoJogos'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Salão de Jogos</span>
                                </div>`
                            }
            
                            if(caracteristica == 'condominioFechado'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Condomínio Fechado</span>
                                </div>`
                            }
            
                            if(caracteristica == 'portaria24h'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Portaria 24h</span>
                                </div>`
                            }
            
                            if(caracteristica == 'onibus'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Ônibus</span>
                                </div>`
                            }
            
                            if(caracteristica == 'playground'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Playground</span>
                                </div>`
                            }
            
                            if(caracteristica == 'elevador'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Elevador</span>
                                </div>`
                            }
            
                            if(caracteristica == 'academiaCondominio'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Academia</span>
                                </div>`
                            }
                            if(caracteristica == 'saunaCondominio'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Sauna</span>
                                </div>`
                            }
            
                            if(caracteristica == 'piscinaCondominio'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Psicina</span>
                                </div>`
                            }
            
                            if(caracteristica == 'aceitaAnimaisCondominio'){
                                dadosAnuncio.innerHTML += 
                                `<div style='color:#fff'>
                                <i aria-hidden="true" class="fa fa-check" style='color:#23B737; font-size: 16px; margin-right: 5px'>
                                </i><span class="texto">Aceita animais</span>
                                </div>`
                            }
                    });
                    dadosAnuncio.innerHTML += 
                            `</div>`
                }
    

            } else {
                console.log(data);
                alert('Não há dados para exibir.');
            }
        } catch (error) {
            console.error('Erro ao buscar dados:', error);
            alert('Ocorreu um erro ao buscar dados.');
        }
    }

    if(document.getElementById('anunciosTable')){
        try {            
            const response = await fetch(`http://api.apptsadm.com.br:3003/anuncios/listar`);
            const data = await response.json();
    
            if (!data.erro) {  
                console.log(data)          
                const anunciosTable = document.getElementById('anunciosTable');
                anunciosTable.innerHTML = ''; // Limpa o conteúdo atual da tabela
    
                // Preenche a tabela com os anúncios recebidos
                data.anuncios.forEach(anuncio => {
                    const row = document.createElement('tr');

                    if(anuncio.disponibilidade == 'Pendente'){                    
                        row.innerHTML = `
                        <td><a href='/anuncio/ver/${anuncio.id}'>${anuncio.nomeCompleto}</a></td>
                        <td><a href='/anuncio/ver/${anuncio.id}'>${anuncio.tituloImovel}</a> <br> ${anuncio.cidade}/${anuncio.estado}</td>
                        <td>${anuncio.celular}</td>
                        <td>${anuncio.email}</td>
                        <td><span style='color:yellow'>${anuncio.disponibilidade}</span></td>
                    `;                   
                    }else if(anuncio.disponibilidade == 'Aprovado'){                    
                        row.innerHTML = `
                        <td><a href='/anuncio/ver/${anuncio.id}'>${anuncio.nomeCompleto}</a></td>
                        <td><a href='/anuncio/ver/${anuncio.id}'>${anuncio.tituloImovel}</a> <br> ${anuncio.cidade}/${anuncio.estado}</td>
                        <td>${anuncio.celular}</td>
                        <td>${anuncio.email}</td>
                        <td><span style='color:green'>${anuncio.disponibilidade}</span></td>
                    `;                    
                    }else{
                        row.innerHTML = `
                        <td><a href='/anuncio/ver/${anuncio.id}'>${anuncio.nomeCompleto}</a></td>
                        <td><a href='/anuncio/ver/${anuncio.id}'>${anuncio.tituloImovel}</a> <br> ${anuncio.cidade}/${anuncio.estado}</td>
                        <td>${anuncio.celular}</td>
                        <td>${anuncio.email}</td>
                        <td><span style='color:red'>${anuncio.disponibilidade}</span></td>
                    `; 
                    }                   
                    
                    anunciosTable.appendChild(row);
                });
            } else {
                console.log(data);
                alert('Não há dados para exibir.');
            }
        } catch (error) {
            console.error('Erro ao buscar dados:', error);
            alert('Ocorreu um erro ao buscar dados.');
        }
    }
    
});
