document.addEventListener("DOMContentLoaded", async () => {
    // Conectar ao Socket.IO
    const socket = io('http://api.apptsadm.com.br:3003');

    // Ouvir novas mensagens via Socket.IO
    socket.on('novaMensagem', (data) => {
        const userEmail = document.getElementById('userEmail').textContent;
        if (userEmail && (data.id_envio === userEmail || data.id_destino === userEmail)) {
            // Atualizar o modal com a nova mensagem
            const userMessages = document.getElementById('userMessages');
            const messageDiv = document.createElement('div');
            messageDiv.className = `message-container ${data.id_envio === userEmail ? 'user' : 'admin'}`;
            messageDiv.innerHTML = `
                <strong>${data.id_envio === userEmail ? 'Você' : 'Admin'}:</strong>
                <p>${data.message}</p>
                <small>${formatarData(data.date)}</small>
            `;
            userMessages.appendChild(messageDiv);

            // Rolar para a última mensagem
            rolarParaFim(userMessages);
        }
    });

    if (document.getElementById('chatTable')) {
        try {
            // Buscar mensagens do servidor
            const response = await fetch(`http://api.apptsadm.com.br:3003/ler/mensagem/contato@app.tsadm.com.br`);
            const data = await response.json();

            if (!data.erro) {
                console.log(data);

                // Agrupar mensagens por e-mail e manter apenas a última mensagem de cada usuário
                const mensagensAgrupadas = agruparMensagensPorEmail(data.chat);

                // Preencher a tabela com as mensagens agrupadas
                const chatTable = document.getElementById('chatTable');
                chatTable.innerHTML = ''; // Limpa o conteúdo atual da tabela

                mensagensAgrupadas.forEach(mensagem => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>
                            <a href="#" class="user-link" data-email="${mensagem.id_envio}">
                                ${mensagem.id_envio}
                            </a>
                        </td>
                        <td>${mensagem.mensagem}</td>
                        <td>${formatarData(mensagem.date)}</td>
                    `;
                    chatTable.appendChild(row);
                });

                // Adicionar evento de clique para abrir o modal
                document.querySelectorAll('.user-link').forEach(link => {
                    link.addEventListener('click', (e) => {
                        e.preventDefault();
                        const userEmail = link.getAttribute('data-email');
                        abrirModal(userEmail);
                    });
                });
            } else {
                console.log(data);
                alert('Não há dados para exibir.');
            }
        } catch (error) {
            console.error('Erro ao buscar dados:', error);
            alert('Ocorreu um erro ao buscar dados.');
        }
    }

    // Adicionar evento de envio de resposta
    document.getElementById('sendReply')?.addEventListener('click', enviarResposta);
});

// Função para abrir o modal e carregar as mensagens do usuário
async function abrirModal(userEmail) {
    // Definir o e-mail do usuário no título do modal
    document.getElementById('userEmail').textContent = userEmail;

    // Buscar todas as mensagens do usuário
    try {
        const response = await fetch(`http://api.apptsadm.com.br:3003/ler/mensagem/${userEmail}`);
        const data = await response.json();

        if (!data.erro) {
            const userMessages = document.getElementById('userMessages');
            userMessages.innerHTML = ''; // Limpar mensagens anteriores

            // Exibir as mensagens no modal
            data.chat.forEach(mensagem => {
                const messageDiv = document.createElement('div');
                messageDiv.className = `message-container ${mensagem.id_envio === userEmail ? 'user' : 'admin'}`;
                messageDiv.innerHTML = `
                    <strong>${mensagem.id_envio === userEmail ? 'Você' : 'Admin'}:</strong>
                    <p>${mensagem.mensagem}</p>
                    <small>${formatarData(mensagem.date)}</small>
                `;
                userMessages.appendChild(messageDiv);
            });

            // Rolar para a última mensagem
            rolarParaFim(userMessages);
        } else {
            alert('Erro ao carregar mensagens do usuário.');
        }
    } catch (error) {
        console.error('Erro ao buscar mensagens do usuário:', error);
        alert('Ocorreu um erro ao buscar mensagens do usuário.');
    }

    // Abrir o modal
    const modal = new bootstrap.Modal(document.getElementById('chatModal'));
    modal.show();
}

// Função para enviar uma resposta
async function enviarResposta() {
    const userEmail = document.getElementById('userEmail').textContent;
    const replyMessage = document.getElementById('replyMessage').value;

    if (!replyMessage.trim()) {
        alert('Digite uma mensagem para enviar.');
        return;
    }

    try {
        const response = await fetch('http://api.apptsadm.com.br:3003/enviar/mensagem/', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({
                id_envio: 'contato@app.tsadm.com.br',
                id_destino: userEmail,
                message: replyMessage,
                date: new Date().toISOString(),
            }),
        });

        if (response.ok) {
            // Limpar o campo de resposta
            document.getElementById('replyMessage').value = '';

            // Recarregar as mensagens no modal
            abrirModal(userEmail);
        } else {
            alert('Erro ao enviar a mensagem.');
        }
    } catch (error) {
        console.error('Erro ao enviar a mensagem:', error);
        alert('Ocorreu um erro ao enviar a mensagem.');
    }
}

// Função para agrupar mensagens por e-mail e manter apenas a última mensagem de cada usuário
function agruparMensagensPorEmail(mensagens) {
    const mensagensAgrupadas = {};

    mensagens.forEach(mensagem => {
        // Ignorar mensagens enviadas pelo administrador
        if (mensagem.id_envio === 'contato@app.tsadm.com.br') {
            return;
        }

        // Verificar se já existe uma mensagem para este e-mail
        if (!mensagensAgrupadas[mensagem.id_envio] || new Date(mensagem.date) > new Date(mensagensAgrupadas[mensagem.id_envio].date)) {
            // Manter apenas a mensagem mais recente
            mensagensAgrupadas[mensagem.id_envio] = mensagem;
        }
    });

    // Converter o objeto de volta para um array
    return Object.values(mensagensAgrupadas);
}

// Função para formatar a data no formato dd/mm/aaaa - hh:mm
function formatarData(data) {
    const date = new Date(data);
    const dia = String(date.getDate()).padStart(2, '0'); // Adiciona zero à esquerda se necessário
    const mes = String(date.getMonth() + 1).padStart(2, '0'); // Mês começa em 0, então adicionamos 1
    const ano = date.getFullYear();
    const horas = String(date.getHours()).padStart(2, '0');
    const minutos = String(date.getMinutes()).padStart(2, '0');

    return `${dia}/${mes}/${ano} - ${horas}:${minutos}`;
}

// Função para rolar para o final da lista de mensagens
function rolarParaFim(elemento) {
    if (elemento) {
        console.log(elemento)
        console.log(elemento.lastElementChild)
        setTimeout(() => {
            const ultimaMensagem = elemento.lastElementChild;
            if (ultimaMensagem) {
                ultimaMensagem.scrollIntoView({ behavior: "smooth" });
            }
        }, 1000);
    }
}
