document.addEventListener("DOMContentLoaded", async () => {

    if(document.getElementById('imoveisTable')){
        try {            
            const response = await fetch(`http://api.apptsadm.com.br:3003/imovel/listar`);
            const data = await response.json();
    
            if (!data.erro) {  
                //console.log(data)          
                const imoveisTable = document.getElementById('imoveisTable');
                const statusFilter = document.getElementById('statusFilter');
                imoveisTable.innerHTML = ''; // Limpa o conteúdo atual da tabela
    
                // Preenche a tabela com os anúncios recebidos
                data.imoveis.forEach(imovel => {
                    const row = document.createElement('tr');
                    
                    row.setAttribute('data-status', imovel.disponibilidade);

                // Definir cores com base na disponibilidade
                const coresDisponibilidade = {
                    "Pendente": "yellow",
                    "Aprovado Site": "green",
                    "Aprovado Zap": "green",
                    "Aprovado Site/Zap": "green",
                    "Rejeitado": "red" // Caso tenha outro status
                };
                
                // Obter a cor correspondente ou um padrão (vermelho)
                const cor = coresDisponibilidade[imovel.disponibilidade] || "red";
                
                // Definir conteúdo da linha
                row.innerHTML = `
                    <td><a href='/anuncio/ver/${imovel.id}'>${imovel.tituloImovel}</a> <br> ${imovel.cidade}/${imovel.estado}</td>
                    <td><a href='/usuarios/ver/${imovel.usuario_id}'>${imovel.nomeCompleto}</a></td>
                    <td>${imovel.celular}</td>
                    <td>${imovel.email}</td>
                    <td><span style='color:${cor}'>${imovel.disponibilidade}</span></td>
                `;
                  
                    
                    imoveisTable.appendChild(row);
                });
                
                statusFilter.addEventListener('change', () => {
                    const selectedStatus = statusFilter.value;
            
                    // Itera sobre as linhas da tabela e exibe/oculta conforme o status
                    Array.from(imoveisTable.rows).forEach(row => {
                        const rowStatus = row.getAttribute('data-status');
                        if (selectedStatus === 'all' || rowStatus === selectedStatus) {
                            row.style.display = '';
                        } else {
                            row.style.display = 'none';
                        }
                    });
                });
            
                // Ordenação por coluna
                const headers = imoveisTable.querySelectorAll('.sortable');
                headers.forEach(header => {
                    header.addEventListener('click', () => {
                        const column = Array.from(headers).indexOf(header);
                        const rows = Array.from(tbody.rows);
            
                        // Alterna entre ascendente e descendente
                        const isAscending = header.classList.toggle('asc');
                        header.classList.toggle('desc', !isAscending);
            
                        // Ordena as linhas
                        rows.sort((a, b) => {
                            const aText = a.cells[column].textContent.trim();
                            const bText = b.cells[column].textContent.trim();
                            return isAscending ? aText.localeCompare(bText) : bText.localeCompare(aText);
                        });
            
                        // Reanexa as linhas na nova ordem
                        rows.forEach(row => tbody.appendChild(row));
                    });
                });
                
                
            } else {
                //console.log(data);
                alert('Não há dados para exibir.');
            }
        } catch (error) {
            console.error('Erro ao buscar dados:', error);
            alert('Ocorreu um erro ao buscar dados.');
        }
    }
    
});
