document.addEventListener("DOMContentLoaded", async () => {

    if(document.getElementById('usuariosTable')){
        try {            
            const response = await fetch(`http://api.apptsadm.com.br:3003/usuarios/listar`);
            const data = await response.json();
    
            if (!data.erro) {  
                console.log(data)          
                const usuariosTable = document.getElementById('usuariosTable');
                usuariosTable.innerHTML = ''; // Limpa o conteúdo atual da tabela
    
                // Preenche a tabela com os anúncios recebidos
                data.usuarios.forEach(usuarios => {
                    const row = document.createElement('tr');

                    if(usuarios.disponibilidade == 'Pendente'){                    
                        row.innerHTML = `
                        <td><a href='/usuarios/ver/${usuarios.id}'>${usuarios.nomeCompleto}</a></td>
                        <td>${usuarios.celular}</td>
                        <td>${usuarios.email}</td>
                    `;                   
                    }else if(usuarios.disponibilidade == 'Aprovado'){                    
                        row.innerHTML = `
                        <td><a href='/usuarios/ver/${usuarios.id}'>${usuarios.nomeCompleto}</a></td>
                        <td>${usuarios.celular}</td>
                        <td>${usuarios.email}</td>
                    `;                    
                    }else{
                        row.innerHTML = `
                        <td><a href='/usuarios/ver/${usuarios.id}'>${usuarios.nomeCompleto}</a></td>
                        <td>${usuarios.celular}</td>
                        <td>${usuarios.email}</td>
                    `; 
                    }                   
                    
                    usuariosTable.appendChild(row);
                });
            } else {
                console.log(data);
                alert('Não há dados para exibir.');
            }
        } catch (error) {
            console.error('Erro ao buscar dados:', error);
            alert('Ocorreu um erro ao buscar dados.');
        }
    }
    
    if(document.getElementById('dadosUsuario')){

        const urlParts = window.location.pathname.split('/');
        const id = urlParts[urlParts.length - 1]; 

        try {            
            const response = await fetch(`http://api.apptsadm.com.br:3003/usuario/${id}`);
            const data = await response.json();
            console.log(data)
            
             const nomeUsuario = document.getElementById('nomeUsuario');
                const dadosUsuario = document.getElementById('dadosUsuario');
                
                nomeUsuario.innerHTML = `${data.usuario_nome}`;
            
                
                
                if(data.usuario_cpf){
                    dadosUsuario.innerHTML += `<p class='text'><span class='title'>CPF</span>: ${data.usuario_cpf}</p>`;
                }
                
                if(data.usuario_celular){
                    dadosUsuario.innerHTML += `<p class='text'><span class='title'>Celular</span>: ${data.usuario_celular}</p>`;
                }
                if(data.usuario_email){
                    dadosUsuario.innerHTML += `<p class='text'><span class='title'>Email</span>: ${data.usuario_email}</p>`;
                }
                if(data.usuario_rg){
                    dadosUsuario.innerHTML += `<p class='text'><span class='title'>RG</span>: ${data.usuario_rg} - <span class='title'>Órgão Expedidor</span>: ${data.usuario_orgaoRg}</p>`;
                }
                if(data.usuario_nacionalidade){
                    dadosUsuario.innerHTML += `<p class='text'><span class='title'>Nacionalidade</span>: ${data.usuario_nacionalidade}</p>`;
                }
                if(data.usuario_profissao){
                    dadosUsuario.innerHTML += `<p class='text'><span class='title'>Profissão</span>: ${data.usuario_profissao}</p>`;
                }
                if(data.usuario_estadoCivil){
                    dadosUsuario.innerHTML += `<p class='text'><span class='title'>Estado Civil</span>: ${data.usuario_estadoCivil}</p>`;
                }
                if(data.usuario_sexo){
                    dadosUsuario.innerHTML += `<p class='text'><span class='title'>Sexo</span>: ${data.usuario_sexo}</p>`;
                }
                
                if(document.getElementById('imoveisTable')){
                    const imoveisTable = document.getElementById('imoveisTable');
                    imoveisTable.innerHTML = ''; // Limpa o conteúdo atual da tabela
        
                    if(data.imoveis[0].tituloImovel != null){
                        // Preenche a tabela com os anúncios recebidos
                    data.imoveis.forEach(anuncio => {
                        const row = document.createElement('tr');
    
                        if(anuncio.disponibilidade == 'Pendente'){                    
                            row.innerHTML = `
                            <td><a href='/anuncio/ver/${anuncio.imovel_id}'>${anuncio.tituloImovel}</a></td>
                            <td><a href='/anuncio/ver/${anuncio.imovel_id}'>${anuncio.tituloImovel}</a> <br> ${anuncio.descricaoImovel}</td>
                            <td>${anuncio.cidade}/${anuncio.estado}</td>
                            <td><span style='color:yellow'>${anuncio.disponibilidade}</span></td>
                        `;                   
                        }else if(anuncio.disponibilidade == 'Aprovado'){                    
                            row.innerHTML = `
                            <td><a href='/anuncio/ver/${anuncio.imovel_id}'>${anuncio.tituloImovel}</a></td>
                            <td><a href='/anuncio/ver/${anuncio.imovel_id}'>${anuncio.tituloImovel}</a> <br> ${anuncio.descricaoImovel}</td>
                            <td>${anuncio.cidade}/${anuncio.estado}</td>
                            <td><span style='color:green'>${anuncio.disponibilidade}</span></td>
                        `;                    
                        }else{
                            row.innerHTML = `
                            <td><a href='/anuncio/ver/${anuncio.imovel_id}'>${anuncio.tituloImovel}</a></td>
                            <td><a href='/anuncio/ver/${anuncio.imovel_id}'>${anuncio.tituloImovel}</a> <br> ${anuncio.descricaoImovel}</td>
                            <td>${anuncio.cidade}/${anuncio.estado}</td>
                            <td><span style='color:red'>${anuncio.disponibilidade}</span></td>
                        `; 
                        }                   
                        
                        imoveisTable.appendChild(row);
                    });
                    } 
                }
    
            
        } catch (error) {
            console.error('Erro ao buscar dados:', error);
            alert('Ocorreu um erro ao buscar dados.');
        }
    }
    
});
