const express = require('express');
const router = express.Router();
const controller = require('../controllers/boletoController');

router.get('/segundavia/boleto/:id', controller.gerarBoleto);
router.get('/app/usuarios/:email', controller.getUsuarios); 
router.get('/app/usuarios/deslogado/:email', controller.getUsuariosDeslogado); 
//router.get('/app/impressao/:id', controller.getIdImpressao); 
router.get('/app/report', controller.getReport);
router.get('/app/report/:id', controller.getIdReport);
router.get('/app/contratos/:id', controller.getContratos);
router.get('/app/contratos/all/:idUser', controller.getAllContratos);
router.get('/app/imoveis/:id', controller.getImoveis);
router.get('/app/contrato/user/:id', controller.getIdContrato);
router.get('/app/contrato/docs/:id', controller.getDocsContrato);
router.get('/app/repasse/:id', controller.getRepasse);
router.get('/app/manutencoes/administrador/listar', controller.getAllManutencao);
router.get('/app/manutencoes/listar/:idUser', controller.getManutencao);
router.post('/app/manutencoes/adicionar/', controller.inserirManutencao);
router.post('/app/manutencoes/atualizar/', controller.atualizarManutencao);

module.exports = router;
