const express = require('express');
const router = express.Router();
const multer = require('multer');
const controller = require('../controllers/curriculoController');
const path = require('path');

// Configuração do multer para salvar o arquivo
const storage = multer.diskStorage({
    destination: (req, file, cb) => {
        cb(null, 'public/uploads/'); // Pasta onde os arquivos serão salvos
    },
    filename: (req, file, cb) => {
        cb(null, Date.now() + path.extname(file.originalname));  // Gera um nome único para o arquivo
    }
});

const upload = multer({ storage: storage });

// Rota para exibir a página de login
router.get('/curriculos/adicionar', controller.renderAddCurriculo);

// Rota para adicionar o currículo, incluindo o upload de arquivo
router.post('/curriculo/adicionar', upload.single('curriculo'), controller.addCurriculo);

// Rota para exibir todos os currículos
router.get('/curriculos', controller.renderCurriculos);

router.get('/curriculo/:id', controller.getCurriculoId);

router.get('/curriculos/ver/:id', controller.renderCurriculoId);

module.exports = router;
