const express = require('express');
const router = express.Router();
const multer = require('multer');
const controller = require('../controllers/usuariosController');

// Rota para exibir todos os currículos
router.get('/usuarios', controller.renderUsuarios);
router.get('/usuarios/ver/:id', controller.renderUsuarioId);
router.get('/usuarios/listar', controller.getAllUsuarios);
router.get('/usuario/:id', controller.getUsuarioId);
router.get('/perfil/:email', controller.getUsuario);
router.put('/editar/usuario/:id', controller.updateUser);

module.exports = router;
