/*const express = require('express');
const bodyParser = require('body-parser');
const path = require('path');
const authRoutes = require('./routes/loginRoute');
const homeRoutes = require('./routes/homeRoute');
const curriculoRoutes = require('./routes/curriculoRoute');
const anuncieRoutes = require('./routes/anuncieRoute');
const imoveisRoutes = require('./routes/imoveisRoute');
const usuariosRoutes = require('./routes/usuariosRoute');
const aluguelExpressRoutes = require('./routes/aluguelExpressRoute');
const boletoRoutes = require('./routes/boletoRoute');
const cors = require('cors');
const app = express();

// Configuração do EJS como template engine
app.set('view engine', 'ejs');
app.set('views', path.join(__dirname, 'views'));

// Middleware para servir arquivos estáticos e processar formulários
app.use(express.static(path.join(__dirname, 'public')));
app.use(express.json()); // Adicionado para processar JSON
app.use(bodyParser.urlencoded({ extended: true }));

app.use(cors());

// Usar as rotas de autenticação
app.use('/', authRoutes);
app.use('/', homeRoutes);
app.use('/', curriculoRoutes);
app.use('/', anuncieRoutes);
app.use('/', imoveisRoutes);
app.use('/', usuariosRoutes);
app.use('/', aluguelExpressRoutes);
app.use('/', boletoRoutes);

// Iniciar o servidor
const PORT = 3003;
app.listen(PORT, () => {
  console.log(`Servidor rodando em http://localhost:${PORT}`);
});*/

const express = require('express');
const http = require('http'); // Importar o módulo HTTP
const path = require('path');
const cors = require('cors');
const socketIo = require('socket.io'); // Importar o Socket.IO
const chatController = require('./controllers/chatController'); // Importar o controlador

// Configuração do Express
const app = express();
const server = http.createServer(app); // Criar servidor HTTP

// Configuração do EJS como template engine
app.set('view engine', 'ejs');
app.set('views', path.join(__dirname, 'views'));

// Middleware para servir arquivos estáticos e processar formulários
app.use(express.static(path.join(__dirname, 'public')));
app.use(express.json()); // Adicionado para processar JSON
app.use(express.urlencoded({ extended: true })); // Substitui o bodyParser.urlencoded
app.use(cors());

// Rotas
const authRoutes = require('./routes/loginRoute');
const homeRoutes = require('./routes/homeRoute');
const curriculoRoutes = require('./routes/curriculoRoute');
const anuncieRoutes = require('./routes/anuncieRoute');
const imoveisRoutes = require('./routes/imoveisRoute');
const usuariosRoutes = require('./routes/usuariosRoute');
const aluguelExpressRoutes = require('./routes/aluguelExpressRoute');
const boletoRoutes = require('./routes/boletoRoute');
const chatRoutes = require('./routes/chatRoute');
const visitaRoutes = require('./routes/visitasRoute');
const grupozapRouts = require('./routes/grupozapRoute');

app.use('/', authRoutes);
app.use('/', homeRoutes);
app.use('/', curriculoRoutes);
app.use('/', anuncieRoutes);
app.use('/', imoveisRoutes);
app.use('/', usuariosRoutes);
app.use('/', aluguelExpressRoutes);
app.use('/', boletoRoutes);
app.use('/', chatRoutes);
app.use('/', visitaRoutes);
app.use('/', grupozapRouts);

// Inicializar o Socket.IO com o servidor HTTP
const io = socketIo(server, {
    cors: {
        origin: '*', // Permitir todas as origens (ou especifique o domínio do seu app Flutter)
        methods: ['GET', 'POST'], // Métodos HTTP permitidos
    },
});

// Compartilhar o `io` com o controlador
chatController.initSocket(io);

// Iniciar o servidor
const PORT = 3003;
server.listen(PORT, () => {
    console.log(`Servidor rodando em http://localhost:${PORT}`);
});
