const pool = require('../config_db');

exports.renderAddAnuncio = (req, res) => {
    res.render('adicionar-anuncio');
};

exports.addAnuncio = async (req, res) => {
    try {
        let id_usuario;
        var { nomeCompleto, relacao, dataNasc, cpf, telefone, email, rg, orgaoRg, nacionalidade, profissao, estadoCivil, sexo, cep, logradouro, numero, complemento, bairro, cidade, estado, tituloImovel, descricao, tipo, status, valorAluguel, valorVenda, area, quantidadeQuartos, quantidadeSuites, quantidadeSalas, quantidadeBanheiros, quantidadeVagas, aceitaFiador, aceitaDeposito, aceitaSeguro, valorIptu, valorCondominio, nomeCondominio, caracteristicas, caracteristicasCond, isMobile } = req.body;
        const imagens = req.files;
        
        if (isMobile) {
          // Remove os colchetes e espaços extras ao redor da string
          if (caracteristicas) {
            caracteristicas = caracteristicas.replace(/[\[\]]/g, '').split(', ').map(item => item.trim());
          }
        
          if (caracteristicasCond) {
            caracteristicasCond = caracteristicasCond.replace(/[\[\]]/g, '').split(', ').map(item => item.trim());
          }
        }



        console.log(typeof caracteristicas);
        console.log(caracteristicas);
        console.log(typeof caracteristicasCond);
        console.log(caracteristicasCond);
        
       console.log("nomeCompleto:", nomeCompleto);
        console.log("relacao:", relacao);
        console.log("dataNasc:", dataNasc);
        console.log("cpf:", cpf);
        console.log("telefone:", telefone);
        console.log("email:", email);
        console.log("rg:", rg);
        console.log("orgaoRg:", orgaoRg);
        console.log("nacionalidade:", nacionalidade);
        console.log("profissao:", profissao);
        console.log("estadoCivil:", estadoCivil);
        console.log("sexo:", sexo);
        console.log("cep:", cep);
        console.log("logradouro:", logradouro);
        console.log("numero:", numero);
        console.log("complemento:", complemento);
        console.log("bairro:", bairro);
        console.log("cidade:", cidade);
        console.log("estado:", estado);
        console.log("tituloImovel:", tituloImovel);
        console.log("descricao:", descricao);
        console.log("tipo:", tipo);
        console.log("status:", status);
        console.log("valorAluguel:", valorAluguel);
        console.log("valorVenda:", valorVenda);
        console.log("area:", area);
        console.log("quantidadeQuartos:", quantidadeQuartos);
        console.log("quantidadeSuites:", quantidadeSuites);
        console.log("quantidadeSalas:", quantidadeSalas);
        console.log("quantidadeBanheiros:", quantidadeBanheiros);
        console.log("quantidadeVagas:", quantidadeVagas);
        console.log("aceitaFiador:", aceitaFiador);
        console.log("aceitaDeposito:", aceitaDeposito);
        console.log("aceitaSeguro:", aceitaSeguro);
        console.log("valorIptu:", valorIptu);
        console.log("valorCondominio:", valorCondominio);
        console.log("nomeCondominio:", nomeCondominio);
        console.log("caracteristicas:", caracteristicas);
        console.log("caracteristicasCond:", caracteristicasCond);
        
        
        console.log(imagens);


       const queryUser = 'SELECT * FROM usuarios WHERE cpf = ?';
        const queryInsertUser = `INSERT INTO usuarios (nomeCompleto, dataNasc, cpf, celular, email, rg, orgaoRg, nacionalidade, profissao, estadoCivil, sexo) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`;
        const valuesInsertUser = [nomeCompleto, dataNasc, cpf, telefone, email, rg, orgaoRg, nacionalidade, profissao, estadoCivil, sexo];

        const queryImovel = `INSERT INTO imoveis (id_usuario, relacao, nomeCompleto, celular, tituloImovel, descricaoImovel, tipoImovel, area, status, quartos, suites, salas, banheiros, vagas, cep, logradouro, numero, complemento, bairro, cidade, estado, valorAluguel, valorVenda, valorIptu, valorCondominio, nomeCondominio, aceitaFiador, aceitaDeposito, aceitaSeguro) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)`;

        // Verifica se o usuário já existe
        const [result] = await pool.query(queryUser, [cpf]);

        if (result.length > 0) {
            id_usuario = result[0].id;
        } else {
            const [insertResult] = await pool.query(queryInsertUser, valuesInsertUser);
            id_usuario = insertResult.insertId;
        }

        // Inserir imóvel
        const valuesImovel = [id_usuario, relacao, nomeCompleto, telefone, tituloImovel, descricao, tipo, area, status, quantidadeQuartos, quantidadeSuites, quantidadeSalas, quantidadeBanheiros, quantidadeVagas, cep, logradouro, numero, complemento, bairro, cidade, estado, valorAluguel, valorVenda, valorIptu, valorCondominio, nomeCondominio, aceitaFiador, aceitaDeposito, aceitaSeguro];
        const [insertImovelResult] = await pool.query(queryImovel, valuesImovel);
        const imovelId = insertImovelResult.insertId;

        // Inserir imagens
        if (imagens && imagens.length > 0) {
            const queryInsertImagem = `INSERT INTO imagens_imovel (id_imovel, nome, link) VALUES (?, ?, ?)`;
            for (const imagem of imagens) {
                const path = `uploads/${imagem.filename}`;
                await pool.query(queryInsertImagem, [imovelId, imagem.filename, path]);
            }
        }

        // Inserir características
        const caracteristicasMap = { 'Academia': 3, 'Aceita Animais': 9, 'Ar Condicionado': 1, 'Closet': 10, 'Cozinha Americana': 15, 'Cozinha Planejada': 14, 'Home Theater': 4, 'Jardim de Inverno': 5, 'Lareira': 11, 'Piscina': 7, 'Sauna': 6, 'TV a Cabo': 8, 'Varanda': 13, 'Varanda Gourmet': 12, 'Vista mar': 16 };
        const caracteristicasCondominioMap = { 'Lavanderia': 1, 'Bicicletário': 2, 'Churrasqueira': 3, 'Espaço Gourmet': 4, 'Quadra de Squash': 5, 'Quadra de Tênis': 6, 'Quadra Poliesportiva': 7, 'Salão de Festas': 8, 'Salão de Jogos': 9, 'Condomínio Fechado': 10, 'Portaria 24 horas': 11, 'Ônibus': 12, 'PlayGround': 13, 'Elevador': 14, 'Academia': 15, 'Sauna': 16, 'Piscina': 17, 'Aceita Animais': 18 };

        const queryInsertCaracteristicas = `INSERT INTO imovel_caracteristicas (imovel_id, caracteristica_id) VALUES (?, ?)`;
        const queryInsertCaracteristicasCondominio = `INSERT INTO imovel_caracteristicas_condominio (imovel_id, caracteristica_id) VALUES (?, ?)`;
        
        console.log(typeof caracteristicas);

        for (const caracteristica of caracteristicas || []) {
            const caracteristicaId = caracteristicasMap[caracteristica];
            if (caracteristicaId) {
                await pool.query(queryInsertCaracteristicas, [imovelId, caracteristicaId]);
                console.log('Passou caracteristicas')
                console.log(queryInsertCaracteristicas)
                console.log(caracteristicaId)
            }
        }

        for (const caracteristicaCond of caracteristicasCond || []) {
            const caracteristicaCondId = caracteristicasCondominioMap[caracteristicaCond];
            if (caracteristicaCondId) {
                await pool.query(queryInsertCaracteristicasCondominio, [imovelId, caracteristicaCondId]);
            }
        }

        res.status(200).json({ message: "Imóvel inserido com sucesso", imovelId });

    } catch (error) {
        console.error("Erro ao adicionar anúncio:", error);
        res.status(500).json({ error: "Erro interno ao adicionar anúncio" });
    }
};


exports.renderAnuncios = (req, res) => {
    res.render('listar-anuncie-imovel');
};

exports.renderAnuncioId = (req, res) => {
    res.render('ver-anuncio');
};


// Função para obter todos os anúncios com todas as informações
exports.getAllAnuncio = async (req, res) => {
    console.log("Entrou nos anuncios");
    
    const query = `
        SELECT 
            i.*, 
            u.id AS usuario_id, u.nomeCompleto AS usuario_nome, u.cpf, u.email, u.dataNasc, 
            u.celular, u.rg, u.orgaoRg, u.nacionalidade, u.profissao, 
            u.estadoCivil, u.sexo,
            GROUP_CONCAT(DISTINCT ic.caracteristica_id ORDER BY ic.caracteristica_id SEPARATOR ', ') AS caracteristicas,
            GROUP_CONCAT(DISTINCT icc.caracteristica_id ORDER BY icc.caracteristica_id SEPARATOR ', ') AS caracteristicas_condominio,
            GROUP_CONCAT(DISTINCT img.link ORDER BY img.id SEPARATOR ', ') AS imagens
        FROM imoveis i
        JOIN usuarios u ON i.id_usuario = u.id
        LEFT JOIN imovel_caracteristicas ic ON i.id = ic.imovel_id
        LEFT JOIN imovel_caracteristicas_condominio icc ON i.id = icc.imovel_id
        LEFT JOIN imagens_imovel img ON i.id = img.id_imovel
        WHERE i.disponibilidade IN ('Pendente')
        GROUP BY i.id, u.id
        ORDER BY i.id DESC`;

    try {
        // Usa o método `promise().query()` para trabalhar com Promises
        const [results] = await pool.query(query);
        /*console.log("Retornando todos")
        console.log(results)*/
        res.json({ anuncios: results });

    } catch (err) {
        console.error("Erro ao buscar anúncios:", err.message);
        res.status(500).send("Erro ao buscar os anúncios.");
    }
};

// Função para obter um anúncio pelo ID com todas as informações
/*exports.getAnuncioId = async (req, res) => {
    const { id } = req.params;

    const query = `
        SELECT 
            i.*, 
            u.id AS usuario_id, u.nomeCompleto AS usuario_nome, u.cpf, u.email, u.dataNasc, 
            u.celular, u.rg, u.orgaoRg, u.nacionalidade, u.profissao, 
            u.estadoCivil, u.sexo,
            GROUP_CONCAT(DISTINCT ic.caracteristica_id ORDER BY ic.caracteristica_id SEPARATOR ', ') AS caracteristicas,
            GROUP_CONCAT(DISTINCT icc.caracteristica_id ORDER BY icc.caracteristica_id SEPARATOR ', ') AS caracteristicas_condominio,
            GROUP_CONCAT(DISTINCT img.link ORDER BY img.id SEPARATOR ', ') AS imagens
        FROM imoveis i
        JOIN usuarios u ON i.id_usuario = u.id
        LEFT JOIN imovel_caracteristicas ic ON i.id = ic.imovel_id
        LEFT JOIN imovel_caracteristicas_condominio icc ON i.id = icc.imovel_id
        LEFT JOIN imagens_imovel img ON i.id = img.id_imovel
        WHERE i.id = ?
        GROUP BY i.id, u.id`;

    try {
        const [results] = await pool.query(query, [id]); // ✅ Uso correto com `await`
        
        if (results.length === 0) {
            return res.status(404).json({ message: "Anúncio não encontrado" });
        }

        res.json(results[0]);

    } catch (err) {
        console.error("Erro ao buscar o anúncio:", err.message);
        res.status(500).send("Erro ao buscar o anúncio.");
    }
};*/

exports.getAnuncioId = async (req, res) => {
    const { id } = req.params;

    const query = `
        SELECT 
            i.*, 
            u.id AS usuario_id, u.nomeCompleto AS usuario_nome, u.cpf, u.email, u.dataNasc, 
            u.celular, u.rg, u.orgaoRg, u.nacionalidade, u.profissao, 
            u.estadoCivil, u.sexo,
            GROUP_CONCAT(DISTINCT ic.caracteristica_id ORDER BY ic.caracteristica_id SEPARATOR ',') AS caracteristicas,
            GROUP_CONCAT(DISTINCT icc.caracteristica_id ORDER BY icc.caracteristica_id SEPARATOR ',') AS caracteristicas_condominio,
            GROUP_CONCAT(DISTINCT img.link ORDER BY img.id SEPARATOR ',') AS imagens
        FROM imoveis i
        JOIN usuarios u ON i.id_usuario = u.id
        LEFT JOIN imovel_caracteristicas ic ON i.id = ic.imovel_id
        LEFT JOIN imovel_caracteristicas_condominio icc ON i.id = icc.imovel_id
        LEFT JOIN imagens_imovel img ON i.id = img.id_imovel
        WHERE i.id = ?
        GROUP BY i.id, u.id`;

    try {
        const [results] = await pool.query(query, [id]);
        
        if (results.length === 0) {
            return res.status(404).json({ message: "Anúncio não encontrado" });
        }

        let anuncio = results[0];

        // Função auxiliar para buscar os nomes das características
        const getCaracteristicasNomes = async (ids, tabela) => {
            if (!ids) return [];
            const idArray = ids.split(',').map(id => parseInt(id.trim()));
            const [rows] = await pool.query(`SELECT id, nome FROM ${tabela} WHERE id IN (?)`, [idArray]);
            return rows.map(row => row.nome);
        };

        // Buscar os nomes das características
        anuncio.caracteristicas = await getCaracteristicasNomes(anuncio.caracteristicas, 'caracteristicas');
        anuncio.caracteristicas_condominio = await getCaracteristicasNomes(anuncio.caracteristicas_condominio, 'caracteristicas_condominio');
        
        console.log("Retornando anuncio pelo ID");
        console.log(anuncio);

        res.json(anuncio);

    } catch (err) {
        console.error("Erro ao buscar o anúncio:", err.message);
        res.status(500).send("Erro ao buscar o anúncio.");
    }
};


//Aprovar site
exports.aprovarAnuncio = async (req, res) => {
    const { id } = req.params;
    const query = `UPDATE imoveis SET disponibilidade = ? WHERE id = ?`;
    const values = ['Aprovado Site', id];

    try {
        const [result] = await pool.query(query, values); // ✅ Uso correto com `await`
        
        if (result.affectedRows === 0) {
            return res.status(404).json({ message: "Anúncio não encontrado" });
        }

        return res.status(200).json({
            message: "Anuncio aprovado com sucesso",
            anuncio: id // Retorna os dados atualizados
        });
        
    } catch (err) {
        console.error("Erro ao alterar imóvel:", err.message);
        res.status(500).send('Erro ao alterar imóvel.');
    }
};

//Aprovar zap
exports.aprovarAnuncioZap = async (req, res) => {
    const { id } = req.params;
    const query = `UPDATE imoveis SET disponibilidade = ? WHERE id = ?`;
    const values = ['Aprovado Zap', id];

    try {
        const [result] = await pool.query(query, values); // ✅ Uso correto com `await`
        
        if (result.affectedRows === 0) {
            return res.status(404).json({ message: "Anúncio não encontrado" });
        }

        return res.status(200).json({
            message: "Anuncio aprovado com sucesso",
            anuncio: id // Retorna os dados atualizados
        });
        
    } catch (err) {
        console.error("Erro ao alterar imóvel:", err.message);
        res.status(500).send('Erro ao alterar imóvel.');
    }
};

//Aprovar site zap
exports.aprovarAnuncioSiteZap = async (req, res) => {
    const { id } = req.params;
    const query = `UPDATE imoveis SET disponibilidade = ? WHERE id = ?`;
    const values = ['Aprovado Site/Zap', id];

    try {
        const [result] = await pool.query(query, values); // ✅ Uso correto com `await`
        
        if (result.affectedRows === 0) {
            return res.status(404).json({ message: "Anúncio não encontrado" });
        }

        return res.status(200).json({
            message: "Anuncio aprovado com sucesso",
            anuncio: id // Retorna os dados atualizados
        });
        
    } catch (err) {
        console.error("Erro ao alterar imóvel:", err.message);
        res.status(500).send('Erro ao alterar imóvel.');
    }
};

exports.reprovarAnuncio = async (req, res) => {
    const { id } = req.params;
    const query = `UPDATE imoveis SET disponibilidade = ? WHERE id = ?`;
    const values = ['Reprovado', id];

    try {
        const [result] = await pool.query(query, values); // ✅ Uso correto com `await`
        
        if (result.affectedRows === 0) {
            return res.status(404).json({ message: "Anúncio não encontrado" });
        }

        return res.status(200).json({
            message: "Anuncio reprovado com sucesso",
            anuncio: id // Retorna os dados atualizados
        });
        
    } catch (err) {
        console.error("Erro ao alterar imóvel:", err.message);
        res.status(500).send('Erro ao alterar imóvel.');
    }
};

exports.pendenteAnuncio = async (req, res) => {
    const { id } = req.params;
    const query = `UPDATE imoveis SET disponibilidade = ? WHERE id = ?`;
    const values = ['Pendente', id];

    try {
        const [result] = await pool.query(query, values); // ✅ Uso correto com `await`
        
        if (result.affectedRows === 0) {
            return res.status(404).json({ message: "Anúncio não encontrado" });
        }

        return res.status(200).json({
            message: "Anuncio pendente.",
            anuncio: id // Retorna os dados atualizados
        });
        
    } catch (err) {
        console.error("Erro ao alterar imóvel:", err.message);
        res.status(500).send('Erro ao alterar imóvel.');
    }
};


