const jwt = require('jsonwebtoken');
const bcrypt = require('bcrypt');
const axios = require('axios');
const pool = require('../config_db');
const cookie = require('cookie'); // Correção: importando o pacote cookie
require('dotenv').config();

// Cabeçalhos para as requisições
const headers = {
    'Content-Type': 'application/json',
    app_token: '49c6a333-7dc5-4b44-aa2d-9a36abd2e7b5',
    access_token: '7cf3d372-01f0-44f7-b294-d1d80c6fb2db'
};

exports.getLoginPage = (req, res) => {
    res.render('login');
};


exports.loginUser = async (req, res) => {
    const { email, senha } = req.body;

    if (!email || !senha) {
        return res.status(400).json({ message: 'Email e senha são obrigatórios.' });
    }

    try {
        const connection = await pool.getConnection();

        // Busca o usuário no banco
        const [rows] = await connection.execute(
            'SELECT * FROM usuarios WHERE email = ?',
            [email]
        );

        connection.release();

        if (rows.length === 0) {
            return res.status(401).json({ message: 'Usuário não encontrado.' });
        }

        const user = rows[0];
        const hash = user.senha;

        // Verificando a senha com bcrypt
        const isMatch = await bcrypt.compare(senha, hash);

        if (isMatch) {
            const secret = process.env.SECRET;
            try {
                // Gerando o token JWT
                const token = jwt.sign(
                    { id: user.id },
                    secret,
                );

                // Retornando o token no corpo da resposta
                return res.status(200).json({
                    message: 'Login bem-sucedido.',
                    token: token,
                    user: user
                });
            } catch (error) {
                console.error(error);
                return res.status(500).json({ message: 'Erro ao gerar o token.' });
            }
        } else {
            return res.status(401).json({ message: 'Senha incorreta.' });
        }

    } catch (error) {
        console.error('Erro ao fazer login:', error);
        return res.status(500).json({ message: 'Erro interno do servidor.' });
    }
};

exports.loginAdministrador = async (req, res) => {
    const { email, senha } = req.body;

    if (!email || !senha) {
        return res.status(400).json({ message: 'Email e senha são obrigatórios.' });
    }

    try {
        const connection = await pool.getConnection();

        // Busca o usuário no banco
        const [rows] = await connection.execute(
            'SELECT * FROM administradores WHERE email = ?',
            [email]
        );

        connection.release();

        if (rows.length === 0) {
            return res.status(401).json({ message: 'Usuário não encontrado.' });
        }

        const user = rows[0];
        const hash = user.senha;

        // Verificando a senha com bcrypt
        const isMatch = await bcrypt.compare(senha, hash);

        if (isMatch) {
            const secret = process.env.SECRET;
            try {
                // Gerando o token JWT
                const token = jwt.sign(
                    { id: user.id },
                    secret,
                );

                // Retornando o token no corpo da resposta
                return res.status(200).json({
                    message: 'Login bem-sucedido.',
                    token: token,
                    user: user
                });
            } catch (error) {
                console.error(error);
                return res.status(500).json({ message: 'Erro ao gerar o token.' });
            }
        } else {
            return res.status(401).json({ message: 'Senha incorreta.' });
        }

    } catch (error) {
        console.error('Erro ao fazer login:', error);
        return res.status(500).json({ message: 'Erro interno do servidor.' });
    }
};

exports.login = async (req, res) => {
    const { email, senha } = req.body;

    try {
        const connection = await pool.getConnection();

        // Busca o usuário no banco
        const [rows] = await connection.execute(
            'SELECT id, email, senha FROM administradores WHERE email = ?',
            [email]
        );

        connection.release();

        if (rows.length === 0) {
            return res.status(401).json({ message: 'Usuário não encontrado.' });
        }

        const user = rows[0]; // Corrigido para usar a variável 'user'
        const hash = user.senha;

        // Verificando a senha com bcrypt
        const isMatch = await bcrypt.compare(senha, hash); // Usando async/await

        if (isMatch) {
            const secret = process.env.SECRET;
            try {
                // Gerando o token JWT
                const token = jwt.sign(
                    { id: user.id },
                    secret, // Adicionando expiração de 1 hora ao token
                );

                // Retornando o token no corpo da resposta
                return res.status(200).json({
                    message: 'Login bem-sucedido.',
                    token: token
                });
            } catch (error) {
                console.error(error);
                return res.status(500).json({ message: 'Erro ao gerar o token.' });
            }
        } else {
            return res.status(401).json({ message: 'Senha incorreta.' });
        }

    } catch (error) {
        console.error('Erro ao fazer login:', error);
        return res.status(500).json({ message: 'Erro interno do servidor.' });
    }
};

exports.register = async (req, res) => {
    const { email, senha, tipo } = req.body;

    // Validação dos campos
    if (!email || !senha) {
        return res.status(400).json({ message: 'Email e senha são obrigatórios.' });
    }
    
    const url = `https://api.superlogica.net/v2/financeiro/clientes?apenasColunasPrincipais=0&apenasPessoasJuridicas=0&pagina=1&itensPorPagina=50&pesquisaEmTudo=${email}&status=2`;

    try {
        const response = await axios.get(url, { headers });
        
        if (response.data.length > 0) {
            console.log(response.data)
            var nome = response.data[0]['st_nome_sac']
            console.log(nome)
            try {
        const connection = await pool.getConnection();

        // Verifica se o email já está cadastrado
        const [rows] = await connection.execute(
            'SELECT * FROM usuarios WHERE email = ?',
            [email]
        );

        if (rows.length > 0) {
            connection.release();
            return res.status(400).json({ message: 'Email já cadastrado.' });
        }

        // Criptografa a senha
        const salt = await bcrypt.genSalt(10);
        const hash = await bcrypt.hash(senha, salt);

        // Insere o novo usuário no banco de dados
        const [result] = await connection.execute(
            'INSERT INTO usuarios (nomeCompleto, email, senha, tipo) VALUES (?, ?, ?, ?)',
            [nome, email, hash, tipo]
        );

        connection.release();

        // Retorna o ID do usuário cadastrado
        return res.status(201).json({ message: 'Usuário cadastrado com sucesso.', userId: result.insertId });

    } catch (error) {
        console.error('Erro ao cadastrar usuário:', error);
        return res.status(500).json({ message: 'Erro interno do servidor.' });
    }
        } else {
        //console.log('Executando2')
            res.status(404).json({ message: 'Usuário não encontrado' });
        }
    } catch (err) {
        //console.log('Executando3')
        console.error("Erro ao buscar usuários:", err.message);
        res.status(500).json({ message: 'Erro ao buscar usuários' });
    }

    
};

exports.getAllAdministradores = async (req, res) => {
    const query = `
        SELECT 
            *
        FROM administradores u
        ORDER BY u.nome ASC`;

    try {
        // Usa o método `promise().query()` para trabalhar com Promises
        const [results] = await pool.query(query);
        res.json({ administradores: results });

    } catch (err) {
        console.error("Erro ao buscar administradores:", err.message);
        res.status(500).send("Erro ao buscar os administradores.");
    }
};

exports.deleteAdministrador = async (req, res) => {
    const { id } = req.params;  // O ID do administrador será passado como parâmetro na URL


    const query = `
        DELETE FROM administradores WHERE id = ?`;

    try {
        const [result] = await pool.query(query, [id]);

        if (result.affectedRows > 0) {
            res.status(200).json({ message: "Administrador excluído com sucesso" });
        } else {
            res.status(404).json({ message: "Administrador não encontrado" });
        }
    } catch (err) {
        console.error("Erro ao excluir administrador:", err.message);
        res.status(500).send("Erro ao excluir o administrador.");
    }
};

exports.updateAdministrador = async (req, res) => {
    console.log('Entrou aqui');
    const { id } = req.params;  // O ID do administrador será passado como parâmetro na URL
    const { nome, email, senha } = req.body;  // Os dados a serem atualizados são passados no corpo da requisição

    // Validação básica
    if (!nome || !email) {
        return res.status(400).json({ message: "Nome e email são obrigatórios" });
    }

    // Se a senha foi fornecida, precisamos criptografá-la
    let hashedPassword = null;

    if (senha && senha !== '') {
        const salt = await bcrypt.genSalt(10);  // Gera o salt para criptografar a senha
        hashedPassword = await bcrypt.hash(senha, salt);  // Criptografa a senha
    }

    // Monta a query dinamicamente para atualizar ou não a senha
    let query = `
        UPDATE administradores
        SET nome = ?, email = ?`;
    
    let queryParams = [nome, email];
    
    if (senha && senha !== '') {
        query += ', senha = ?';  // Se a senha for fornecida, adiciona à query
        queryParams.push(hashedPassword);  // Adiciona a senha criptografada aos parâmetros
    }

    query += ` WHERE id = ?`;  // A cláusula WHERE é sempre necessária
    queryParams.push(id);  // Adiciona o ID no final dos parâmetros

    try {
        const [result] = await pool.query(query, queryParams);

        if (result.affectedRows > 0) {
            res.status(200).json({ message: "Administrador atualizado com sucesso" });
        } else {
            res.status(404).json({ message: "Administrador não encontrado" });
        }
    } catch (err) {
        console.error("Erro ao atualizar administrador:", err.message);
        res.status(500).send("Erro ao atualizar o administrador.");
    }
};

exports.registerAdmin = async (req, res) => {
    const { nome, email, senha, corretor, administrador} = req.body; // Inclua outros campos necessários
    
    console.log(req.body)

    if (!nome || !email || !senha) {
        return res.status(400).json({ message: 'Todos os campos são obrigatórios.' });
    }

    try {
        const connection = await pool.getConnection();

        // Verifica se o e-mail já está registrado no banco de dados
        const [existingUser] = await connection.execute(
            'SELECT * FROM administradores WHERE email = ?',
            [email]
        );

        if (existingUser.length > 0) {
            connection.release();
            return res.status(400).json({ message: 'Este e-mail já está registrado.' });
        }

        // Hash da senha antes de salvar no banco de dados
        const salt = await bcrypt.genSalt(10);
        const hashedPassword = await bcrypt.hash(senha, salt);
        
        var valuesRegister = []
        if(corretor){
            valuesRegister = [nome, email, hashedPassword, 'Corretor']
        }else if(administrador){
            valuesRegister = [nome, email, hashedPassword, 'Administrador']
        }

        // Insere o novo usuário no banco de dados
        const [result] = await connection.execute(
            'INSERT INTO administradores (nome, email, senha, tipo) VALUES (?, ?, ?, ?)',
            valuesRegister
        );

        connection.release();

        // Se a inserção for bem-sucedida, gera o token JWT
        const user = {
            id: result.insertId,
            nome,
            email
        };

        const secret = process.env.SECRET;

        try {
            const token = jwt.sign(
                { id: user.id },
                secret,
            );

            // Retorna a resposta com o token
            return res.status(201).json({
                message: 'Cadastro bem-sucedido.',
                token: token,
                user: user
            });
        } catch (error) {
            console.error(error);
            return res.status(500).json({ message: 'Erro ao gerar o token.' });
        }

    } catch (error) {
        console.error('Erro ao cadastrar usuário:', error);
        return res.status(500).json({ message: 'Erro interno do servidor.' });
    }
};

/**
 * POST /usuarios/verify-delete
 * Entrada: { email, cpf, senha }
 * Saída (200): { message, deleteToken }
 * Saída (401/400): { message }
 */
exports.verifyDeleteUser = async (req, res) => {
  try {
    const { email, cpf, senha } = req.body || {};
    if (!email || !cpf || !senha) {
      return res.status(400).json({ message: 'Email, CPF e senha são obrigatórios.' });
    }

    const cpfDigits = String(cpf).replace(/\D/g, '');

    const connection = await pool.getConnection();
    const [rows] = await connection.execute(
      'SELECT id, email, cpf, senha, nomeCompleto FROM usuarios WHERE email = ? AND REPLACE(REPLACE(REPLACE(cpf, ".", ""), "-", ""), "/", "") = ?',
      [email, cpfDigits]
    );
    connection.release();

    if (rows.length === 0) {
      return res.status(401).json({ message: 'Usuário não encontrado com estas credenciais.' });
    }

    const user = rows[0];
    const ok = await bcrypt.compare(senha, user.senha);
    if (!ok) {
      return res.status(401).json({ message: 'Senha incorreta.' });
    }

    // Gera um token curto apenas para exclusão de conta
    const deleteToken = jwt.sign(
      { sub: user.id, action: 'delete_account' },
      process.env.SECRET,
      { expiresIn: '10m' } // 10 minutos
    );

    return res.status(200).json({
      message: 'Autenticado. Você pode prosseguir com a exclusão.',
      deleteToken
    });
  } catch (err) {
    console.error('Erro em verifyDeleteUser:', err);
    return res.status(500).json({ message: 'Erro interno do servidor.' });
  }
};

/**
 * DELETE /usuarios
 * Entrada: { deleteToken }
 * Saída (200): { message }
 */
exports.deleteUser = async (req, res) => {
  try {
    const { deleteToken } = req.body || {};
    if (!deleteToken) {
      return res.status(400).json({ message: 'deleteToken é obrigatório.' });
    }

    let payload;
    try {
      payload = jwt.verify(deleteToken, process.env.SECRET);
    } catch {
      return res.status(401).json({ message: 'Token inválido ou expirado.' });
    }

    if (payload.action !== 'delete_account' || !payload.sub) {
      return res.status(401).json({ message: 'Token não autorizado para exclusão.' });
    }

    const userId = payload.sub;

    const [result] = await pool.query('DELETE FROM usuarios WHERE id = ? LIMIT 1', [userId]);

    if (result.affectedRows > 0) {
      return res.status(200).json({ message: 'Conta excluída com sucesso.' });
    } else {
      return res.status(404).json({ message: 'Usuário não encontrado.' });
    }
  } catch (err) {
    console.error('Erro em deleteUser:', err);
    return res.status(500).json({ message: 'Erro interno do servidor.' });
  }
};

