const axios = require('axios');
const fs = require('fs');
const path = require('path');
const pool = require('../config_db');
const { stringify } = require('flatted');

exports.renderUsuarios = (req, res) => {
    res.render('usuarios');
};

// Função para obter todos os anúncios com todas as informações
exports.getAllUsuarios = async (req, res) => {
    const query = `
        SELECT 
            *
        FROM usuarios u
        ORDER BY u.id DESC`;

    try {
        // Usa o método `promise().query()` para trabalhar com Promises
        const [results] = await pool.query(query);
        res.json({ usuarios: results });

    } catch (err) {
        console.error("Erro ao buscar anúncios:", err.message);
        res.status(500).send("Erro ao buscar os anúncios.");
    }
};

exports.renderUsuarioId = (req, res) => {
    res.render('ver-usuario');
};


exports.getUsuarioId = async (req, res) => {
    const { id } = req.params;
    

    const query = `
        SELECT 
            u.id AS usuario_id, 
            u.nomeCompleto AS usuario_nome, 
            u.celular AS usuario_celular, 
            u.cpf AS usuario_cpf,
            u.email AS usuario_email,
            u.dataNasc AS usuario_dataNasc,
            u.rg AS usuario_rg,
            u.orgaoRg AS usuario_orgaoRg,
            u.nacionalidade AS usuario_nacionalidade,
            u.profissao AS usuario_profissao,
            u.estadoCivil AS usuario_estadoCivil,
            u.sexo AS usuario_sexo,
            i.id AS imovel_id,
            i.id_usuario, 
            i.relacao, 
            i.tituloImovel, 
            i.descricaoImovel, 
            i.tipoImovel, 
            i.area, 
            i.status AS imovel_status, 
            i.quartos, 
            i.suites, 
            i.salas, 
            i.banheiros, 
            i.vagas, 
            i.cep, 
            i.logradouro, 
            i.numero, 
            i.complemento, 
            i.bairro, 
            i.cidade, 
            i.estado, 
            i.valorAluguel, 
            i.valorVenda, 
            i.valorIptu, 
            i.valorCondominio, 
            i.nomeCondominio, 
            i.aceitaFiador, 
            i.aceitaDeposito, 
            i.aceitaSeguro, 
            i.disponibilidade
        FROM usuarios u
        LEFT JOIN imoveis i ON i.id_usuario = u.id
        WHERE u.id = ?
    `;

    try {
        const [results] = await pool.query(query, [id]);

        if (results.length === 0) {
            return res.status(404).json({ message: "Usuário ou imóveis não encontrados" });
        }
        //console.log(results)

        // Estrutura de dados com usuário e seus imóveis
        const usuario = {
            usuario_id: results[0].usuario_id,
            usuario_nome: results[0].usuario_nome,
            usuario_celular: results[0].usuario_celular,
            usuario_cpf: results[0].usuario_cpf,
            usuario_email: results[0].usuario_email,
            usuario_dataNasc: results[0].usuario_dataNasc,
            usuario_rg: results[0].usuario_rg,
            usuario_orgaoRg: results[0].usuario_orgaoRg,
            usuario_nacionalidade: results[0].usuario_nacionalidade,
            usuario_profissao: results[0].usuario_profissao,
            usuario_estadoCivil: results[0].usuario_estadoCivil,
            imoveis: results.map(imovel => ({
                imovel_id: imovel.imovel_id,
                id_usuario: imovel.id_usuario,
                relacao: imovel.relacao,
                tituloImovel: imovel.tituloImovel,
                descricaoImovel: imovel.descricaoImovel,
                tipoImovel: imovel.tipoImovel,
                area: imovel.area,
                imovel_status: imovel.imovel_status,
                quartos: imovel.quartos,
                suites: imovel.suites,
                salas: imovel.salas,
                banheiros: imovel.banheiros,
                vagas: imovel.vagas,
                cep: imovel.cep,
                logradouro: imovel.logradouro,
                numero: imovel.numero,
                complemento: imovel.complemento,
                bairro: imovel.bairro,
                cidade: imovel.cidade,
                estado: imovel.estado,
                valorAluguel: imovel.valorAluguel,
                valorVenda: imovel.valorVenda,
                valorIptu: imovel.valorIptu,
                valorCondominio: imovel.valorCondominio,
                nomeCondominio: imovel.nomeCondominio,
                aceitaFiador: imovel.aceitaFiador,
                aceitaDeposito: imovel.aceitaDeposito,
                aceitaSeguro: imovel.aceitaSeguro,
                disponibilidade: imovel.disponibilidade
            }))
        };

        res.json(usuario);

    } catch (err) {
        console.error("Erro ao buscar o usuário e imóveis:", err.message);
        res.status(500).send("Erro ao buscar o usuário e imóveis.");
    }
};

// Cabeçalhos para as requisições
const headers = {
    'Content-Type': 'application/json',
    app_token: '49c6a333-7dc5-4b44-aa2d-9a36abd2e7b5',
    access_token: '7cf3d372-01f0-44f7-b294-d1d80c6fb2db'
};

exports.getUsuario = async (req, res) => {
    const email = req.params.email;  // Obtém o e-mail passado na URL

    const url = `https://api.superlogica.net/v2/financeiro/clientes?apenasColunasPrincipais=0&apenasPessoasJuridicas=0&pagina=1&itensPorPagina=50&pesquisaEmTudo=${email}&status=2`;

    try {
        const response = await axios.get(url, { headers });
        
        if (response.data.length > 0) {
            //console.log(response.data)
            res.json({ usuario: response.data });
        } else {
        //console.log('Executando2')
            res.status(404).json({ message: 'Usuário não encontrado' });
        }
    } catch (err) {
        //console.log('Executando3')
        console.error("Erro ao buscar usuários:", err.message);
        res.status(500).json({ message: 'Erro ao buscar usuários' });
    }
};

exports.updateUser = async (req, res) => {
    //console.log('Acessou');
    const userId = req.params.id; // Obtém o ID do usuário da URL
    //console.log(userId);
    //console.log('body');
    const userData = req.body; // Obtém os dados do usuário a serem atualizados no corpo da requisição

    const url = `http://apps.superlogica.net/imobiliaria/api/proprietarios`;

    // Prepara os dados para enviar para o PUT da API
    let data = {
        ID_PESSOA_PES: userId, // O ID do usuário
        ST_NOME_PES: userData.nome,
        ST_CNPJ_PES: userData.cnpj,
        ST_CELULAR_PES: userData.celular,
        ST_RG_PES: userData.rg,
        ST_ORGÃO_PES: userData.orgao,
        DT_NASCIMENTO_PES: userData.dataNascimento,
        ST_NACIONALIDADE_PES: userData.nacionalidade,
        ST_CEP_PES: userData.cep,
        ST_ENDERECO_PES: userData.logradouro,
        ST_NUMERO_PES: userData.numero,
        ST_COMPLEMENTO_PES: userData.complemento,
        ST_BAIRRO_PES: userData.bairro,
        ST_CIDADE_PES: userData.cidade,
        ST_ESTADO_PES: userData.estado
    };

    // Remove campos não preenchidos (undefined, null ou strings vazias)
    data = Object.fromEntries(
        Object.entries(data).filter(([_, value]) => value !== undefined && value !== null && value !== "")
    );

    //console.log(data);

    try {
        // Headers da requisição
        const headers = {
            'Content-Type': 'application/json',
            app_token: '49c6a333-7dc5-4b44-aa2d-9a36abd2e7b5',
            access_token: '7cf3d372-01f0-44f7-b294-d1d80c6fb2db'
        };

        // Realiza a requisição PUT para a API externa
        const response = await axios.put(url, data, { headers });
        //console.log(response)

        // Retorna a resposta de sucesso
        res.json({ message: 'Usuário atualizado com sucesso', data: response.data });
    } catch (err) {
        console.log('Erro ao atualizar usuário:', err.message);
        res.status(500).json({ message: 'Erro ao atualizar usuário', error: err.message });
    }
};


