document.addEventListener("DOMContentLoaded", async () => {
    if(document.getElementById("tipoInteresse")){
        const tipoInteresse = document.getElementById("tipoInteresse");
        const tipoAcessoContent = document.getElementById("tipoAcessoContent");
        const tipoAcesso = document.getElementById("tipoAcesso");
        const pessoaFisicaFields = document.getElementById("pessoaFisicaFields");
        const pessoaJuridicaFields = document.getElementById("pessoaJuridicaFields");
        const enderecoFields = document.getElementById("enderecoFields");
        const cepInput = document.getElementById("cep");
        const inputCurriculo = document.getElementById("inputCurriculo");

        tipoInteresse.addEventListener("change", () => {
            tipoAcessoContent.classList.remove('hidden')
        });

        tipoAcesso.addEventListener("change", () => {    
            if (tipoAcesso.value == "Pessoa Física") {
                console.log(tipoAcesso.value)
                pessoaFisicaFields.classList.remove('hidden');
                pessoaJuridicaFields.classList.add('hidden');
                enderecoFields.classList.remove('hidden');
                if(tipoInteresse.value == 'Sou prestador de serviços' || tipoInteresse.value == 'Quero ser um franqueado' ){
                    inputCurriculo.classList.add('hidden')  
                }else{        
                    inputCurriculo.classList.remove('hidden')
                }
            } else if (tipoAcesso.value == "Pessoa Jurídica") {
                inputCurriculo.classList.add('hidden') 
                pessoaFisicaFields.classList.add('hidden');
                pessoaJuridicaFields.classList.remove('hidden');
                enderecoFields.classList.remove('hidden');
            }else{
                pessoaFisicaFields.classList.add('hidden');
                pessoaJuridicaFields.classList.add('hidden');
                enderecoFields.classList.add('hidden');
                inputCurriculo.classList.add('hidden')  
            }
        });

        cepInput.addEventListener("blur", async () => {
            const cep = cepInput.value.replace(/\D/g, "");
            if (cep.length === 8) {
                try {
                        document.getElementById("logradouro").value = "Carregando...";
                        document.getElementById("bairro").value = "Carregando...";
                        document.getElementById("cidade").value = "Carregando...";
                        document.getElementById("estado").value = "Carregando...";
                    const response = await fetch(`https://viacep.com.br/ws/${cep}/json/`);
                    const data = await response.json();
                    if (!data.erro) {
                        document.getElementById("logradouro").value = data.logradouro || "";
                        document.getElementById("bairro").value = data.bairro || "";
                        document.getElementById("cidade").value = data.localidade || "";
                        document.getElementById("estado").value = data.uf || "";
                    } else {
                        alert("CEP não encontrado.");
                    }
                } catch {
                    alert("Erro ao buscar o endereço. Tente novamente.");
                }
            } else {
                alert("CEP inválido.");
            }
        });

        document.getElementById("formCurriculo").addEventListener("submit", async (e) => {
            e.preventDefault();
            const formData = new FormData(e.target);
            const data = Object.fromEntries(formData.entries());

            console.log(data)
            try {
                const response = await fetch("/curriculo/adicionar", {
                    method: "POST",
                    body: formData
                });

                if (response.ok) {
                    window.location.href = '/curriculos';
                } else {
                    alert("Erro ao enviar os dados. Tente novamente.");
                }
            } catch {
                alert("Erro ao conectar com o servidor.");
            }
        });
    }
    
    if(document.getElementById("dadosCurriculo")){
        
        const dadosCurriculo = document.getElementById("dadosCurriculo");
        const nomeUsuario = document.getElementById("nomeUsuario");


        const urlParts = window.location.pathname.split('/');
        const id = urlParts[urlParts.length - 1]; 


        try {            
            const response = await fetch(`http://api.apptsadm.com.br:3003/curriculo/${id}`);
            const data = await response.json();

    
            if (!data.erro) {  
                console.log(data)  
                
                if(data.nome){
                    nomeUsuario.innerHTML = `${data.nome}`;
                }if(data.nomeResponsavel){
                    nomeUsuario.innerHTML = `${data.nomeResponsavel}`;
                }
                dadosCurriculo.innerHTML = ``;
                
                if(data.tipoInteresse){
                    dadosCurriculo.innerHTML += `
                <p class='text'><b>Tipo de Interesse:</b> ${data.tipoInteresse}</p>`;
                }
                
                if(data.tipoAcesso == 'Pessoa Física'){
                    
                    if(data.email){
                        dadosCurriculo.innerHTML += `
                    <p class='text'><b>Email:</b> ${data.email}</p>`;
                    }
                    
                    if(data.celular){
                        dadosCurriculo.innerHTML += `
                    <p class='text'><b>Celular:</b> ${data.celular}</p>`;
                    }
                    
                    if(data.dataNascimento){
                        dadosCurriculo.innerHTML += `
                    <p class='text'><b>Data de nascimento:</b> ${data.dataNascimento}</p>`;
                    }
                    
                    if(data.rg){
                        dadosCurriculo.innerHTML += `
                    <p class='text'><b>RG:</b> ${data.rg} - <b>Órgão Expedidor:</b> ${data.orgao}</p>`;
                    }
                    
                    if(data.cpf){
                        dadosCurriculo.innerHTML += `
                    <p class='text'><b>CPF:</b> ${data.cpf}</p>`;
                    }
                    
                    if(data.sexo){
                        dadosCurriculo.innerHTML += `
                    <p class='text'><b>Sexo:</b> ${data.sexo}</p>`;
                    }
                    if(data.estadoCivil){
                        dadosCurriculo.innerHTML += `
                    <p class='text'><b>Estado Civil:</b> ${data.estadoCivil}</p>`;
                    }
                }
                
                if(data.tipoAcesso == 'Pessoa Jurídica'){
                    
                    if(data.razaoSocial){
                        dadosCurriculo.innerHTML += `
                    <p class='text'><b>Razão Social:</b> ${data.razaoSocial}</p>`;
                    }
                    
                    if(data.cnpj){
                        dadosCurriculo.innerHTML += `
                    <p class='text'><b>CNPJ:</b> ${data.cnpj}</p>`;
                    }
                    
                    if(data.email){
                        dadosCurriculo.innerHTML += `
                    <p class='text'><b>Email:</b> ${data.email}</p>`;
                    }
                    
                    if(data.celular){
                        dadosCurriculo.innerHTML += `
                    <p class='text'><b>Celular:</b> ${data.celular}</p>`;
                    }
                    
                    
                }

                if(data.tipoInteresse == 'Prestador de Serviços'){
                    
                    if(data.formaPagamento == 'Doc/TED'){
                        dadosCurriculo.innerHTML += `
                        <br><p class='text'><b>Forma de pagamento: </b> Doc/TED</p>`;
                        if(data.nomeFavorecido){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>Nome do favorecido:</b> ${data.nomeFavorecido}</p>`;
                        }
                        if(data.cpfFavorecido){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>CPF do favorecido:</b> ${data.cpfFavorecido}</p>`;
                        }
                        if(data.banco){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>Banco:</b> ${data.banco}</p>`;
                        }
                        
                        if(data.agencia){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>Agência:</b> ${data.agencia} - <b>Conta:</b> ${data.conta}</p>`;
                        }
                        if(data.tipoConta){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>Tipo de conta:</b> ${data.tipoConta}</p>`;
                        }
                        if(data.operacao){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>Operação:</b> ${data.operacao}</p>`;
                        }
                        if(data.descricaoServicos){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>Serviços:</b> ${data.descricaoServicos}</p><br>`;
                        }
                    }

                    if(data.formaPagamento == 'Pix'){
                        dadosCurriculo.innerHTML += `
                        <br><p class='text'><b>Forma de pagamento: </b> Pix</p>`;
                        if(data.nomeFavorecido){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>Nome do favorecido:</b> ${data.nomeFavorecido}</p>`;
                        }
                        if(data.cpfFavorecido){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>CPF do favorecido:</b> ${data.cpfFavorecido}</p>`;
                        }
                        if(data.banco){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>Banco:</b> ${data.banco}</p>`;
                        }
                        
                        if(data.agencia){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>Agência:</b> ${data.agencia} - <b>Conta:</b> ${data.conta}</p>`;
                        }
                        if(data.tipoConta){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>Tipo de conta:</b> ${data.tipoConta}</p>`;
                        }
                        if(data.operacao){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>Operação:</b> ${data.operacao}</p>`;
                        }
                        if(data.chavePix){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>Chave Pix:</b> ${data.chavePix}</p>`;
                        }
                        if(data.descricaoServicos){
                            dadosCurriculo.innerHTML += `
                        <p class='text'><b>Serviços:</b> ${data.descricaoServicos}</p><br>`;
                        }
                    }

                    
                    
                    
                }
                
                if(data.cep){
                        dadosCurriculo.innerHTML += `
                    <p class='text'><b>Endereço:</b> <br>${data.logradouro}, ${data.numero}</p>`;
                    }
                    
                if(data.complemento){
                    dadosCurriculo.innerHTML += `
                <p class='text'><b>Complemento:</b> ${data.complemento}</p>`;
                }
                
                if(data.cep){
                    dadosCurriculo.innerHTML += `
                <p class='text'>${data.bairro} - ${data.cidade}/${data.estado}<br><b>CEP:</b> ${data.cep}</p>`;
                }
                
                if(data.creci){
                    dadosCurriculo.innerHTML += `<p class='text'><b>CRECI:</b> ${data.creci}</p>`
                }
                
                if(data.creciJuridico){
                    dadosCurriculo.innerHTML += `<p class='text'><b>CRECI:</b> ${data.creciJuridico}</p>`
                }
                
                if(data.anexo){
                    dadosCurriculo.innerHTML += `<a href='http://api.apptsadm.com.br/public/${data.anexo}' class='btn' target='_blank'>Ver currículo</a>`
                }else{
                    dadosCurriculo.innerHTML += `<p class='text'><b>Currículo:</b> Não enviado</p>`
                }
                    
            }                
            
        } catch (error) {
            console.error('Erro ao buscar dados:', error);
            alert('Ocorreu um erro ao buscar dados.');
        }
    }
  
});