document.addEventListener("DOMContentLoaded", async () => {

    if(document.getElementById('anunciosTable')){
        try {            
            const response = await fetch(`http://api.apptsadm.com.br:3003/anuncios/listar`);
            const data = await response.json();
    
            if (!data.erro) {  
                console.log(data)          
                const anunciosTable = document.getElementById('anunciosTable');
                anunciosTable.innerHTML = ''; // Limpa o conteúdo atual da tabela
    
                // Preenche a tabela com os anúncios recebidos
                data.anuncios.forEach(anuncio => {
                    const row = document.createElement('tr');

                    if(anuncio.disponibilidade == 'Pendente'){                    
                        row.innerHTML = `
                        <td><a href='/anuncio/ver/${anuncio.id}'>${anuncio.nomeCompleto}</a></td>
                        <td><a href='/anuncio/ver/${anuncio.id}'>${anuncio.tituloImovel}</a> <br> ${anuncio.cidade}/${anuncio.estado}</td>
                        <td>${anuncio.celular}</td>
                        <td>${anuncio.email}</td>
                        <td><span style='color:yellow'>${anuncio.disponibilidade}</span></td>
                    `;                   
                    }else if(anuncio.disponibilidade == 'Aprovado'){                    
                        row.innerHTML = `
                        <td><a href='/anuncio/ver/${anuncio.id}'>${anuncio.nomeCompleto}</a></td>
                        <td><a href='/anuncio/ver/${anuncio.id}'>${anuncio.tituloImovel}</a> <br> ${anuncio.cidade}/${anuncio.estado}</td>
                        <td>${anuncio.celular}</td>
                        <td>${anuncio.email}</td>
                        <td><span style='color:green'>${anuncio.disponibilidade}</span></td>
                    `;                    
                    }else{
                        row.innerHTML = `
                        <td><a href='/anuncio/ver/${anuncio.id}'>${anuncio.nomeCompleto}</a></td>
                        <td><a href='/anuncio/ver/${anuncio.id}'>${anuncio.tituloImovel}</a> <br> ${anuncio.cidade}/${anuncio.estado}</td>
                        <td>${anuncio.celular}</td>
                        <td>${anuncio.email}</td>
                        <td><span style='color:red'>${anuncio.disponibilidade}</span></td>
                    `; 
                    }                   
                    
                    anunciosTable.appendChild(row);
                });
            } else {
                console.log(data);
                alert('Não há dados para exibir.');
            }
        } catch (error) {
            console.error('Erro ao buscar dados:', error);
            alert('Ocorreu um erro ao buscar dados.');
        }
    }
    
    if(document.getElementById('aluguelExpressTable')){
        try {            
            const response = await fetch(`http://api.apptsadm.com.br:3003/aluguel/express/listar`);
            const data = await response.json();
    
            if (!data.erro) {  
                const aluguelExpressTable = document.getElementById('aluguelExpressTable');
                const statusFilter = document.getElementById('statusFilter');
                aluguelExpressTable.innerHTML = ''; // Limpa o conteúdo atual da tabela
                
                
                const coresDisponibilidade = {
                    "Pendente": "yellow",
                    "Aprovado": "green",
                    "Rejeitado": "red"
                };
                
    
                // Preenche a tabela com os anúncios recebidos
                data.solicitacoes.forEach(aluguel => {
                    
                    const cor = coresDisponibilidade[aluguel.status] || "red";
                    const row = document.createElement('tr');
                    row.setAttribute('data-status', aluguel.status);

                    row.innerHTML = `
                        <td><a href='/aluguel/express/ver/${aluguel.id}'>${aluguel.tituloImovel}</a></td>
                        <td>${aluguel.nomeCompleto}</td>
                        <td>${aluguel.celular}</td>
                        <td>${aluguel.email}</td>
                        <td>${aluguel.garantia}</td>
                        <td>R$ ${aluguel.valorProposta}</td>
                        <td><span style='color:${cor}'>${aluguel.status}</span></td>
                    `;                 
                    
                    aluguelExpressTable.appendChild(row);
                });
                
                statusFilter.addEventListener('change', () => {
                    const selectedStatus = statusFilter.value;
            
                    // Itera sobre as linhas da tabela e exibe/oculta conforme o status
                    Array.from(aluguelExpressTable.rows).forEach(row => {
                        const rowStatus = row.getAttribute('data-status');
                        if (selectedStatus === 'all' || rowStatus === selectedStatus) {
                            row.style.display = '';
                        } else {
                            row.style.display = 'none';
                        }
                    });
                });
            
                // Ordenação por coluna
                const headers = aluguelExpressTable.querySelectorAll('.sortable');
                headers.forEach(header => {
                    header.addEventListener('click', () => {
                        const column = Array.from(headers).indexOf(header);
                        const rows = Array.from(tbody.rows);
            
                        // Alterna entre ascendente e descendente
                        const isAscending = header.classList.toggle('asc');
                        header.classList.toggle('desc', !isAscending);
            
                        // Ordena as linhas
                        rows.sort((a, b) => {
                            const aText = a.cells[column].textContent.trim();
                            const bText = b.cells[column].textContent.trim();
                            return isAscending ? aText.localeCompare(bText) : bText.localeCompare(aText);
                        });
            
                        // Reanexa as linhas na nova ordem
                        rows.forEach(row => tbody.appendChild(row));
                    });
                });
            } else {
                console.log(data);
                alert('Não há dados para exibir.');
            }
        } catch (error) {
            console.error('Erro ao buscar dados:', error);
            alert('Ocorreu um erro ao buscar dados.');
        }
    }
    
});
