/*const express = require('express');
const router = express.Router();
const controller = require('../controllers/chatController');

router.post('/enviar/mensagem', controller.sender);
router.get('/ler/mensagem/:id', controller.getMensagem);

module.exports = router;*/


const express = require('express');
const router = express.Router();
const chatController = require('../controllers/chatController');

// Rota para enviar mensagem
router.post('/enviar/mensagem', chatController.sender);
router.post('/iniciar/atendimento', chatController.iniciarAtendimento);
router.post('/avaliar/atendimento', chatController.avaliarAtendimento);
router.get('/chat', chatController.renderChat);
// Rota para buscar mensagens
router.get('/ler/mensagem/:id', chatController.getMensagem);
router.get('/atendimento/:email', chatController.getAtendimento);
router.get('/atendimentos/all', chatController.getAllAtendimentos);

module.exports = router;