const express = require('express');
const router = express.Router();
const controller = require('../controllers/loginController');

// Rota para exibir a página de login
router.get('/', controller.getLoginPage);

// Rota para processar o login
router.post('/login', controller.login);
router.post('/login/user', controller.loginUser);
router.post('/login/administrador', controller.loginAdministrador);

router.post('/register', controller.register);
router.post('/register/adm', controller.registerAdmin);
router.get('/listar/administrador', controller.getAllAdministradores);
router.post('/excluir/administrador/:id', controller.deleteAdministrador);
router.post('/atualizar/administrador/:id', controller.updateAdministrador);
router.post('/usuarios/verify-delete', controller.verifyDeleteUser);
router.delete('/usuarios', controller.deleteUser);

module.exports = router;

  